from dataclasses import dataclass
from typing import List, Literal

from util.hparams import HyperParams


@dataclass
class MEMITLTIHyperParams(HyperParams):
    # Method
    layers: List[int]
    layer_selection: Literal["all", "random"]
    fact_token: Literal[
        "last", "subject_first", "subject_last", "subject_first_after_last"
    ]
    gnn_num_grad_steps: int
    v_lr: float
    gnn_loss_layer: int
    v_weight_decay: float
    clamp_norm_factor: float
    mid_kl_factor: float
    last_kl_factor: float
    mom2_adjustment: bool
    mom2_update_weight: float

    # Module templates
    rewrite_module_tmp: str
    layer_module_tmp: str
    mlp_module_tmp: str
    attn_module_tmp: str
    ln_f_module: str
    lm_head_module: str

    # Statistics
    mom2_dataset: str
    mom2_n_samples: int
    mom2_dtype: str

    # Midlayer Constraint
    midlayers: List[int]
    constr_pos: str

    # NLL loss
    nll_factor: float = 0.0925

    # Sentence Transformers
    sentence_model_name: str = None
    top_k: int = 4
