# # # # # # # # # # # # # # # #
### MELES sampling min_cnt tuning
# # # # # # # # # # # # # # # #


export SC_SUFFIX="sample6"
for SC_MIN_CNT in 015 020 025 030 050 075 100 125 150 175
do
    for SC_SMPL in SampleSlices SampleSlicesMLES
    do
        python ../../metric_learning.py \
            params.device="$SC_DEVICE" \
            params.train.split_strategy.split_strategy=${SC_SMPL} \
            params.train.split_strategy.cnt_min=${SC_MIN_CNT} \
            params.train.split_strategy.cnt_max=200 \
            params.train.n_epoch=50 \
            model_path.model="models/mles_model_${SC_SUFFIX}_${SC_SMPL}_${SC_MIN_CNT}.p" \
            params.train.checkpoints.save_interval=10 \
            params.train.checkpoints.n_saved=1000 \
            params.train.checkpoints.dirname="models/mles_checkpoints_${SC_SUFFIX}_${SC_SMPL}_${SC_MIN_CNT}/" \
            params.train.checkpoints.filename_prefix="mles" \
            params.train.checkpoints.create_dir=true \
            --conf conf/dataset.hocon conf/mles_params.json
        for SC_EPOCH in 010 020 030 040 050
        do
            python ../../ml_inference.py \
                model_path.model="models/mles_checkpoints_${SC_SUFFIX}_${SC_SMPL}_${SC_MIN_CNT}/mles_model_${SC_EPOCH##+(0)}.pt" \
                output.path="data/mles_${SC_SUFFIX}_${SC_SMPL}_${SC_MIN_CNT}_${SC_EPOCH}" \
                params.device="$SC_DEVICE" --conf conf/dataset.hocon conf/mles_params.json
        done
    done
done

python -m scenario_age_pred compare_approaches --n_workers 5 --models lgb \
    --embedding_file_names "mles_sample6_*.pickle"

                                                         oof_accuracy                                                         test_accuracy
                                                                 mean t_int_l t_int_h    std                           values          mean t_int_l t_int_h    std                           values
name
lgb_embeds: mles_sample6_SampleSlicesMLES_015_010.pickle       0.6242  0.6203  0.6281 0.0032  [0.621 0.622 0.624 0.626 0.629]        0.6231  0.6183  0.6278 0.0038  [0.619 0.620 0.624 0.626 0.627]
lgb_embeds: mles_sample6_SampleSlicesMLES_015_020.pickle       0.6291  0.6228  0.6353 0.0050  [0.622 0.625 0.631 0.633 0.634]        0.6314  0.6261  0.6367 0.0042  [0.628 0.628 0.631 0.632 0.638]
lgb_embeds: mles_sample6_SampleSlicesMLES_015_030.pickle       0.6274  0.6226  0.6322 0.0039  [0.621 0.626 0.629 0.630 0.631]        0.6288  0.6251  0.6325 0.0030  [0.625 0.628 0.628 0.630 0.633]
lgb_embeds: mles_sample6_SampleSlicesMLES_015_040.pickle       0.6305  0.6250  0.6359 0.0044  [0.625 0.628 0.631 0.633 0.636]        0.6333  0.6297  0.6369 0.0029  [0.629 0.632 0.634 0.636 0.636]
lgb_embeds: mles_sample6_SampleSlicesMLES_015_050.pickle       0.6298  0.6245  0.6351 0.0043  [0.622 0.631 0.631 0.632 0.632]        0.6372  0.6337  0.6407 0.0028  [0.633 0.636 0.638 0.638 0.641]

lgb_embeds: mles_sample6_SampleSlicesMLES_020_010.pickle       0.6286  0.6244  0.6328 0.0034  [0.624 0.626 0.631 0.631 0.631]        0.6302  0.6260  0.6344 0.0034  [0.626 0.628 0.631 0.633 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_020_020.pickle       0.6286  0.6264  0.6309 0.0018  [0.627 0.627 0.629 0.629 0.631]        0.6271  0.6242  0.6299 0.0023  [0.625 0.625 0.628 0.628 0.630]
lgb_embeds: mles_sample6_SampleSlicesMLES_020_030.pickle       0.6310  0.6262  0.6358 0.0039  [0.627 0.629 0.630 0.634 0.636]        0.6286  0.6223  0.6349 0.0051  [0.624 0.625 0.628 0.629 0.637]
lgb_embeds: mles_sample6_SampleSlicesMLES_020_040.pickle       0.6324  0.6257  0.6392 0.0054  [0.625 0.631 0.632 0.633 0.641]        0.6295  0.6266  0.6324 0.0023  [0.626 0.629 0.630 0.631 0.631]
lgb_embeds: mles_sample6_SampleSlicesMLES_020_050.pickle       0.6327  0.6276  0.6377 0.0041  [0.628 0.630 0.634 0.634 0.638]        0.6329  0.6279  0.6380 0.0041  [0.628 0.631 0.632 0.634 0.639]

lgb_embeds: mles_sample6_SampleSlicesMLES_025_010.pickle       0.6245  0.6159  0.6330 0.0069  [0.614 0.622 0.628 0.628 0.631]        0.6245  0.6201  0.6289 0.0035  [0.620 0.622 0.624 0.628 0.628]
lgb_embeds: mles_sample6_SampleSlicesMLES_025_020.pickle       0.6307  0.6260  0.6354 0.0038  [0.626 0.628 0.630 0.632 0.636]        0.6307  0.6256  0.6358 0.0041  [0.624 0.630 0.632 0.634 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_025_030.pickle       0.6324  0.6268  0.6380 0.0045  [0.627 0.629 0.633 0.633 0.639]        0.6337  0.6322  0.6351 0.0012  [0.632 0.633 0.634 0.634 0.635]
lgb_embeds: mles_sample6_SampleSlicesMLES_025_040.pickle       0.6344  0.6287  0.6400 0.0046  [0.629 0.632 0.634 0.635 0.642]        0.6379  0.6342  0.6417 0.0030  [0.634 0.636 0.639 0.640 0.641]
lgb_embeds: mles_sample6_SampleSlicesMLES_025_050.pickle       0.6360  0.6336  0.6384 0.0019  [0.633 0.635 0.637 0.637 0.638]        0.6342  0.6279  0.6405 0.0051  [0.627 0.632 0.635 0.636 0.641]

lgb_embeds: mles_sample6_SampleSlicesMLES_030_010.pickle       0.6191  0.6159  0.6224 0.0026  [0.617 0.618 0.618 0.619 0.624]        0.6266  0.6215  0.6317 0.0041  [0.622 0.623 0.627 0.630 0.631]
lgb_embeds: mles_sample6_SampleSlicesMLES_030_020.pickle       0.6221  0.6177  0.6265 0.0035  [0.617 0.621 0.622 0.623 0.627]        0.6351  0.6291  0.6410 0.0048  [0.630 0.631 0.634 0.640 0.640]
lgb_embeds: mles_sample6_SampleSlicesMLES_030_030.pickle       0.6212  0.6148  0.6276 0.0051  [0.616 0.616 0.623 0.623 0.628]        0.6317  0.6293  0.6341 0.0019  [0.629 0.631 0.631 0.633 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_030_040.pickle       0.6244  0.6207  0.6280 0.0030  [0.621 0.622 0.625 0.625 0.629]        0.6331  0.6291  0.6372 0.0033  [0.630 0.631 0.631 0.636 0.637]
lgb_embeds: mles_sample6_SampleSlicesMLES_030_050.pickle       0.6256  0.6163  0.6349 0.0075  [0.617 0.619 0.627 0.631 0.635]        0.6267  0.6205  0.6329 0.0050  [0.620 0.624 0.626 0.631 0.632]

lgb_embeds: mles_sample6_SampleSlicesMLES_050_010.pickle       0.6267  0.6194  0.6341 0.0059  [0.617 0.625 0.629 0.630 0.632]        0.6258  0.6199  0.6317 0.0047  [0.620 0.623 0.625 0.628 0.632]
lgb_embeds: mles_sample6_SampleSlicesMLES_050_020.pickle       0.6301  0.6240  0.6363 0.0049  [0.624 0.629 0.629 0.633 0.636]        0.6269  0.6238  0.6300 0.0025  [0.624 0.625 0.627 0.628 0.630]
lgb_embeds: mles_sample6_SampleSlicesMLES_050_030.pickle       0.6324  0.6240  0.6409 0.0068  [0.625 0.626 0.636 0.637 0.639]        0.6289  0.6244  0.6335 0.0037  [0.624 0.627 0.629 0.631 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_050_040.pickle       0.6337  0.6291  0.6383 0.0037  [0.629 0.632 0.633 0.636 0.639]        0.6303  0.6262  0.6344 0.0033  [0.625 0.629 0.631 0.632 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_050_050.pickle       0.6359  0.6322  0.6395 0.0029  [0.633 0.634 0.635 0.638 0.640]        0.6319  0.6302  0.6337 0.0014  [0.630 0.631 0.632 0.633 0.634]

lgb_embeds: mles_sample6_SampleSlicesMLES_075_010.pickle       0.6211  0.6140  0.6281 0.0057  [0.614 0.619 0.619 0.625 0.629]        0.6289  0.6231  0.6348 0.0047  [0.622 0.626 0.630 0.633 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_075_020.pickle       0.6268  0.6213  0.6323 0.0044  [0.620 0.627 0.628 0.628 0.632]        0.6304  0.6274  0.6334 0.0024  [0.627 0.629 0.631 0.632 0.633]
lgb_embeds: mles_sample6_SampleSlicesMLES_075_030.pickle       0.6260  0.6211  0.6308 0.0039  [0.621 0.624 0.625 0.628 0.631]        0.6373  0.6311  0.6435 0.0050  [0.632 0.636 0.637 0.637 0.645]
lgb_embeds: mles_sample6_SampleSlicesMLES_075_040.pickle       0.6328  0.6269  0.6386 0.0047  [0.629 0.630 0.632 0.632 0.641]        0.6377  0.6337  0.6417 0.0032  [0.634 0.636 0.637 0.640 0.642]
lgb_embeds: mles_sample6_SampleSlicesMLES_075_050.pickle       0.6321  0.6244  0.6399 0.0062  [0.624 0.630 0.631 0.634 0.641]        0.6364  0.6345  0.6383 0.0015  [0.634 0.636 0.637 0.637 0.638]

lgb_embeds: mles_sample6_SampleSlicesMLES_125_010.pickle       0.6265  0.6192  0.6338 0.0059  [0.621 0.623 0.624 0.631 0.634]        0.6163  0.6076  0.6249 0.0070  [0.609 0.612 0.613 0.623 0.624]
lgb_embeds: mles_sample6_SampleSlicesMLES_125_020.pickle       0.6307  0.6282  0.6332 0.0020  [0.628 0.630 0.630 0.632 0.633]        0.6327  0.6307  0.6346 0.0015  [0.631 0.632 0.633 0.634 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_125_030.pickle       0.6325  0.6267  0.6383 0.0046  [0.628 0.629 0.631 0.636 0.639]        0.6309  0.6256  0.6361 0.0042  [0.624 0.630 0.631 0.634 0.635]
lgb_embeds: mles_sample6_SampleSlicesMLES_125_040.pickle       0.6323  0.6250  0.6395 0.0058  [0.626 0.626 0.632 0.638 0.639]        0.6334  0.6317  0.6351 0.0014  [0.632 0.633 0.633 0.634 0.635]
lgb_embeds: mles_sample6_SampleSlicesMLES_125_050.pickle       0.6358  0.6314  0.6401 0.0035  [0.630 0.635 0.636 0.637 0.640]        0.6337  0.6301  0.6373 0.0029  [0.630 0.633 0.634 0.634 0.638]

lgb_embeds: mles_sample6_SampleSlicesMLES_100_010.pickle       0.6214  0.6152  0.6277 0.0050  [0.614 0.620 0.622 0.624 0.627]        0.6187  0.6155  0.6219 0.0026  [0.617 0.617 0.617 0.620 0.623]
lgb_embeds: mles_sample6_SampleSlicesMLES_100_020.pickle       0.6299  0.6229  0.6370 0.0057  [0.624 0.625 0.628 0.636 0.636]        0.6272  0.6204  0.6340 0.0054  [0.619 0.625 0.629 0.632 0.632]
lgb_embeds: mles_sample6_SampleSlicesMLES_100_030.pickle       0.6296  0.6221  0.6370 0.0060  [0.621 0.627 0.630 0.635 0.635]        0.6286  0.6266  0.6306 0.0016  [0.627 0.627 0.629 0.630 0.630]
lgb_embeds: mles_sample6_SampleSlicesMLES_100_040.pickle       0.6316  0.6265  0.6366 0.0041  [0.628 0.628 0.630 0.635 0.636]        0.6310  0.6288  0.6332 0.0018  [0.628 0.631 0.631 0.632 0.633]
lgb_embeds: mles_sample6_SampleSlicesMLES_100_050.pickle       0.6369  0.6300  0.6438 0.0055  [0.632 0.633 0.635 0.639 0.646]        0.6335  0.6310  0.6361 0.0021  [0.631 0.633 0.633 0.635 0.636]

lgb_embeds: mles_sample6_SampleSlicesMLES_150_010.pickle       0.6186  0.6122  0.6251 0.0052  [0.613 0.614 0.619 0.623 0.625]        0.6200  0.6124  0.6276 0.0061  [0.614 0.617 0.618 0.620 0.630]
lgb_embeds: mles_sample6_SampleSlicesMLES_150_020.pickle       0.6247  0.6192  0.6302 0.0045  [0.619 0.621 0.626 0.627 0.630]        0.6274  0.6237  0.6311 0.0030  [0.625 0.626 0.626 0.628 0.632]
lgb_embeds: mles_sample6_SampleSlicesMLES_150_030.pickle       0.6244  0.6131  0.6358 0.0092  [0.614 0.620 0.621 0.633 0.635]        0.6279  0.6231  0.6327 0.0039  [0.624 0.625 0.627 0.630 0.633]
lgb_embeds: mles_sample6_SampleSlicesMLES_150_040.pickle       0.6216  0.6131  0.6300 0.0068  [0.612 0.618 0.621 0.626 0.630]        0.6236  0.6160  0.6312 0.0061  [0.618 0.621 0.622 0.623 0.634]
lgb_embeds: mles_sample6_SampleSlicesMLES_150_050.pickle       0.6164  0.6143  0.6185 0.0017  [0.615 0.616 0.616 0.616 0.619]        0.6179  0.6122  0.6236 0.0046  [0.612 0.615 0.617 0.622 0.623]

lgb_embeds: mles_sample6_SampleSlicesMLES_175_010.pickle       0.6137  0.6030  0.6244 0.0086  [0.600 0.611 0.617 0.618 0.623]        0.6188  0.6155  0.6221 0.0026  [0.614 0.619 0.620 0.620 0.621]
lgb_embeds: mles_sample6_SampleSlicesMLES_175_020.pickle       0.6270  0.6195  0.6344 0.0060  [0.619 0.623 0.629 0.629 0.635]        0.6215  0.6183  0.6247 0.0026  [0.618 0.621 0.622 0.624 0.624]
lgb_embeds: mles_sample6_SampleSlicesMLES_175_030.pickle       0.6282  0.6213  0.6352 0.0056  [0.620 0.626 0.629 0.631 0.635]        0.6313  0.6267  0.6358 0.0037  [0.626 0.629 0.633 0.633 0.635]
lgb_embeds: mles_sample6_SampleSlicesMLES_175_040.pickle       0.6313  0.6231  0.6394 0.0065  [0.621 0.629 0.633 0.634 0.639]        0.6324  0.6276  0.6372 0.0038  [0.627 0.631 0.632 0.635 0.637]
lgb_embeds: mles_sample6_SampleSlicesMLES_175_050.pickle       0.6352  0.6295  0.6409 0.0046  [0.629 0.634 0.635 0.637 0.641]        0.6348  0.6317  0.6379 0.0025  [0.633 0.633 0.634 0.635 0.639]





lgb_embeds: mles_sample6_SampleSlices_015_010.pickle           0.6186  0.6149  0.6224 0.0030  [0.616 0.617 0.618 0.618 0.624]        0.6205  0.6184  0.6227 0.0018  [0.619 0.620 0.620 0.622 0.623]
lgb_embeds: mles_sample6_SampleSlices_015_020.pickle           0.6270  0.6240  0.6299 0.0024  [0.625 0.625 0.626 0.627 0.631]        0.6298  0.6247  0.6349 0.0041  [0.623 0.629 0.631 0.633 0.634]
lgb_embeds: mles_sample6_SampleSlices_015_030.pickle           0.6273  0.6253  0.6292 0.0016  [0.625 0.627 0.627 0.628 0.629]        0.6267  0.6249  0.6286 0.0015  [0.625 0.626 0.628 0.628 0.628]
lgb_embeds: mles_sample6_SampleSlices_015_040.pickle           0.6283  0.6240  0.6327 0.0035  [0.624 0.627 0.628 0.629 0.634]        0.6291  0.6238  0.6345 0.0043  [0.624 0.625 0.631 0.632 0.634]
lgb_embeds: mles_sample6_SampleSlices_015_050.pickle           0.6254  0.6229  0.6279 0.0020  [0.622 0.625 0.625 0.627 0.628]        0.6270  0.6225  0.6315 0.0036  [0.623 0.624 0.627 0.628 0.632]

lgb_embeds: mles_sample6_SampleSlices_020_010.pickle           0.6263  0.6201  0.6324 0.0049  [0.618 0.625 0.628 0.630 0.631]        0.6286  0.6229  0.6343 0.0046  [0.623 0.627 0.627 0.632 0.635]
lgb_embeds: mles_sample6_SampleSlices_020_020.pickle           0.6291  0.6240  0.6343 0.0041  [0.625 0.627 0.629 0.630 0.636]        0.6265  0.6190  0.6339 0.0060  [0.621 0.622 0.624 0.631 0.634]
lgb_embeds: mles_sample6_SampleSlices_020_030.pickle           0.6326  0.6265  0.6388 0.0049  [0.626 0.630 0.633 0.637 0.637]        0.6317  0.6239  0.6396 0.0063  [0.625 0.626 0.634 0.634 0.640]
lgb_embeds: mles_sample6_SampleSlices_020_040.pickle           0.6352  0.6253  0.6451 0.0080  [0.621 0.636 0.639 0.639 0.641]        0.6313  0.6249  0.6376 0.0051  [0.624 0.630 0.632 0.633 0.638]
lgb_embeds: mles_sample6_SampleSlices_020_050.pickle           0.6354  0.6290  0.6419 0.0052  [0.627 0.634 0.636 0.639 0.640]        0.6401  0.6329  0.6472 0.0058  [0.635 0.637 0.639 0.639 0.650]

lgb_embeds: mles_sample6_SampleSlices_025_010.pickle           0.6226  0.6184  0.6267 0.0034  [0.618 0.621 0.623 0.624 0.627]        0.6221  0.6188  0.6255 0.0027  [0.619 0.621 0.621 0.625 0.625]
lgb_embeds: mles_sample6_SampleSlices_025_020.pickle           0.6301  0.6234  0.6369 0.0054  [0.622 0.629 0.629 0.634 0.636]        0.6382  0.6367  0.6397 0.0012  [0.637 0.637 0.638 0.638 0.640]
lgb_embeds: mles_sample6_SampleSlices_025_030.pickle           0.6321  0.6252  0.6391 0.0056  [0.624 0.630 0.634 0.635 0.638]        0.6335  0.6303  0.6368 0.0026  [0.630 0.633 0.634 0.634 0.637]
lgb_embeds: mles_sample6_SampleSlices_025_040.pickle           0.6344  0.6275  0.6414 0.0056  [0.626 0.633 0.635 0.637 0.642]        0.6324  0.6269  0.6379 0.0044  [0.628 0.630 0.631 0.634 0.639]
lgb_embeds: mles_sample6_SampleSlices_025_050.pickle           0.6326  0.6271  0.6382 0.0045  [0.628 0.630 0.631 0.634 0.640]        0.6357  0.6319  0.6394 0.0030  [0.632 0.635 0.635 0.636 0.640]

lgb_embeds: mles_sample6_SampleSlices_030_010.pickle           0.6273  0.6244  0.6301 0.0023  [0.625 0.626 0.627 0.628 0.631]        0.6269  0.6230  0.6308 0.0031  [0.623 0.625 0.627 0.628 0.632]
lgb_embeds: mles_sample6_SampleSlices_030_020.pickle           0.6283  0.6218  0.6348 0.0053  [0.623 0.626 0.626 0.633 0.634]        0.6305  0.6267  0.6344 0.0031  [0.627 0.629 0.629 0.634 0.634]
lgb_embeds: mles_sample6_SampleSlices_030_030.pickle           0.6326  0.6273  0.6379 0.0043  [0.628 0.629 0.633 0.636 0.637]        0.6305  0.6255  0.6355 0.0040  [0.625 0.628 0.632 0.633 0.635]
lgb_embeds: mles_sample6_SampleSlices_030_040.pickle           0.6333  0.6271  0.6394 0.0050  [0.628 0.629 0.634 0.638 0.638]        0.6316  0.6294  0.6338 0.0018  [0.629 0.631 0.632 0.633 0.633]
lgb_embeds: mles_sample6_SampleSlices_030_050.pickle           0.6340  0.6303  0.6376 0.0029  [0.630 0.632 0.635 0.636 0.637]        0.6315  0.6281  0.6350 0.0028  [0.627 0.632 0.632 0.633 0.634]

lgb_embeds: mles_sample6_SampleSlices_050_010.pickle           0.6169  0.6115  0.6222 0.0043  [0.612 0.613 0.618 0.621 0.621]        0.6269  0.6197  0.6342 0.0058  [0.620 0.621 0.628 0.632 0.633]
lgb_embeds: mles_sample6_SampleSlices_050_020.pickle           0.6210  0.6171  0.6249 0.0032  [0.618 0.618 0.621 0.623 0.625]        0.6245  0.6222  0.6267 0.0018  [0.622 0.624 0.625 0.625 0.627]
lgb_embeds: mles_sample6_SampleSlices_050_030.pickle           0.6230  0.6172  0.6288 0.0047  [0.619 0.619 0.621 0.628 0.628]        0.6290  0.6237  0.6343 0.0043  [0.624 0.627 0.629 0.630 0.635]
lgb_embeds: mles_sample6_SampleSlices_050_040.pickle           0.6269  0.6217  0.6322 0.0042  [0.620 0.627 0.627 0.630 0.631]        0.6283  0.6254  0.6312 0.0023  [0.625 0.627 0.628 0.630 0.631]
lgb_embeds: mles_sample6_SampleSlices_050_050.pickle           0.6272  0.6217  0.6326 0.0044  [0.621 0.627 0.627 0.627 0.634]        0.6361  0.6307  0.6414 0.0043  [0.630 0.634 0.635 0.640 0.641]

lgb_embeds: mles_sample6_SampleSlices_075_010.pickle           0.6266  0.6197  0.6335 0.0056  [0.621 0.623 0.625 0.630 0.634]        0.6248  0.6214  0.6282 0.0028  [0.620 0.625 0.626 0.626 0.627]
lgb_embeds: mles_sample6_SampleSlices_075_020.pickle           0.6306  0.6262  0.6351 0.0036  [0.625 0.629 0.632 0.633 0.634]        0.6237  0.6184  0.6290 0.0043  [0.616 0.624 0.625 0.626 0.627]
lgb_embeds: mles_sample6_SampleSlices_075_030.pickle           0.6317  0.6268  0.6366 0.0039  [0.627 0.630 0.631 0.633 0.638]        0.6337  0.6277  0.6398 0.0049  [0.627 0.630 0.634 0.638 0.639]
lgb_embeds: mles_sample6_SampleSlices_075_040.pickle           0.6341  0.6274  0.6409 0.0054  [0.626 0.632 0.635 0.638 0.640]        0.6345  0.6278  0.6413 0.0054  [0.626 0.633 0.637 0.637 0.640]
lgb_embeds: mles_sample6_SampleSlices_075_050.pickle           0.6359  0.6258  0.6460 0.0081  [0.628 0.628 0.637 0.640 0.647]        0.6349  0.6282  0.6417 0.0054  [0.628 0.632 0.635 0.638 0.642]

lgb_embeds: mles_sample6_SampleSlices_100_010.pickle           0.6207  0.6153  0.6261 0.0044  [0.615 0.619 0.619 0.625 0.626]        0.6181  0.6142  0.6221 0.0032  [0.615 0.616 0.617 0.621 0.622]
lgb_embeds: mles_sample6_SampleSlices_100_020.pickle           0.6251  0.6212  0.6291 0.0032  [0.620 0.626 0.626 0.627 0.628]        0.6280  0.6261  0.6299 0.0016  [0.627 0.627 0.627 0.629 0.630]
lgb_embeds: mles_sample6_SampleSlices_100_030.pickle           0.6291  0.6235  0.6348 0.0046  [0.624 0.626 0.628 0.632 0.635]        0.6275  0.6209  0.6342 0.0054  [0.619 0.626 0.627 0.632 0.633]
lgb_embeds: mles_sample6_SampleSlices_100_040.pickle           0.6349  0.6267  0.6430 0.0066  [0.624 0.633 0.637 0.640 0.640]        0.6355  0.6305  0.6404 0.0040  [0.631 0.633 0.636 0.636 0.641]
lgb_embeds: mles_sample6_SampleSlices_100_050.pickle           0.6355  0.6266  0.6444 0.0072  [0.627 0.630 0.638 0.639 0.645]        0.6355  0.6323  0.6386 0.0025  [0.632 0.635 0.635 0.636 0.639]

lgb_embeds: mles_sample6_SampleSlices_125_010.pickle           0.6240  0.6183  0.6297 0.0046  [0.617 0.622 0.626 0.626 0.629]        0.6237  0.6201  0.6272 0.0029  [0.619 0.624 0.624 0.624 0.627]
lgb_embeds: mles_sample6_SampleSlices_125_020.pickle           0.6274  0.6220  0.6329 0.0044  [0.621 0.626 0.629 0.629 0.632]        0.6317  0.6289  0.6345 0.0022  [0.629 0.630 0.632 0.634 0.634]
lgb_embeds: mles_sample6_SampleSlices_125_030.pickle           0.6311  0.6264  0.6359 0.0038  [0.626 0.628 0.633 0.633 0.635]        0.6345  0.6297  0.6393 0.0039  [0.630 0.631 0.635 0.637 0.639]
lgb_embeds: mles_sample6_SampleSlices_125_040.pickle           0.6346  0.6322  0.6371 0.0020  [0.633 0.633 0.634 0.636 0.637]        0.6313  0.6283  0.6344 0.0024  [0.627 0.631 0.633 0.633 0.633]
lgb_embeds: mles_sample6_SampleSlices_125_050.pickle           0.6354  0.6315  0.6393 0.0031  [0.633 0.633 0.634 0.637 0.640]        0.6329  0.6256  0.6403 0.0059  [0.627 0.630 0.631 0.634 0.642]

lgb_embeds: mles_sample6_SampleSlices_150_010.pickle           0.6274  0.6205  0.6344 0.0056  [0.621 0.622 0.630 0.631 0.633]        0.6227  0.6201  0.6254 0.0021  [0.619 0.622 0.623 0.624 0.625]
lgb_embeds: mles_sample6_SampleSlices_150_020.pickle           0.6318  0.6277  0.6360 0.0033  [0.628 0.630 0.631 0.634 0.636]        0.6310  0.6266  0.6354 0.0035  [0.626 0.629 0.633 0.633 0.635]
lgb_embeds: mles_sample6_SampleSlices_150_030.pickle           0.6343  0.6313  0.6373 0.0024  [0.631 0.633 0.634 0.636 0.637]        0.6389  0.6349  0.6428 0.0032  [0.635 0.636 0.640 0.641 0.642]
lgb_embeds: mles_sample6_SampleSlices_150_040.pickle           0.6341  0.6300  0.6382 0.0033  [0.629 0.632 0.635 0.637 0.637]        0.6437  0.6403  0.6471 0.0027  [0.639 0.643 0.644 0.646 0.646]
lgb_embeds: mles_sample6_SampleSlices_150_050.pickle           0.6364  0.6303  0.6426 0.0050  [0.631 0.633 0.634 0.641 0.642]        0.6395  0.6360  0.6429 0.0028  [0.636 0.639 0.639 0.640 0.644]

lgb_embeds: mles_sample6_SampleSlices_175_010.pickle           0.6246  0.6185  0.6307 0.0049  [0.617 0.624 0.625 0.628 0.630]        0.6259  0.6224  0.6295 0.0028  [0.623 0.623 0.628 0.628 0.628]
lgb_embeds: mles_sample6_SampleSlices_175_020.pickle           0.6268  0.6223  0.6313 0.0036  [0.621 0.627 0.628 0.628 0.630]        0.6285  0.6254  0.6316 0.0025  [0.626 0.627 0.627 0.630 0.632]
lgb_embeds: mles_sample6_SampleSlices_175_030.pickle           0.6318  0.6292  0.6345 0.0021  [0.629 0.631 0.631 0.634 0.634]        0.6348  0.6272  0.6424 0.0061  [0.629 0.631 0.633 0.637 0.644]
lgb_embeds: mles_sample6_SampleSlices_175_040.pickle           0.6321  0.6250  0.6393 0.0057  [0.626 0.628 0.631 0.636 0.640]        0.6343  0.6302  0.6385 0.0034  [0.629 0.634 0.635 0.635 0.639]
lgb_embeds: mles_sample6_SampleSlices_175_050.pickle           0.6323  0.6265  0.6381 0.0047  [0.627 0.631 0.631 0.633 0.640]        0.6394  0.6341  0.6447 0.0043  [0.636 0.638 0.638 0.638 0.647]
