import pandas as pd

data = pd.read_csv('data/dynamic_api_call_sequence_per_malware_100_0_306.csv')

data = data.drop_duplicates('hash')
data.to_csv('data/data_drop_duplicates.csv')

df_events = data.melt(id_vars='hash', value_vars=[f't_{i}' for i in range(100)], value_name='api_call')
df_events['time'] = pd.to_numeric(df_events['variable'].str[2:]).astype(float)
df_events = df_events.drop(columns='variable')
df_events['amnt'] = 1

df_events.to_csv('data/events.csv', index=False)
