#!/usr/bin/env bash

echo 'data prepare start...'
python bin/data_prepare.py
echo 'data prepare complete'

spark-submit \
    --master local[16] \
    --name "Malware Make Dataset" \
    --driver-memory 200G \
    --conf spark.sql.shuffle.partitions=60 \
    --conf spark.sql.parquet.compression.codec="snappy" \
    --conf spark.ui.port=4041 \
    --conf spark.local.dir="data/.spark_local_dir" \
    ../../make_datasets_spark.py \
    --data_path data/ \
    --trx_files events.csv \
    --col_client_id "hash" \
    --cols_event_time "#float" "time" \
    --cols_category "api_call" \
    --cols_log_norm "amnt" \
    --target_files "data_drop_duplicates.csv" \
    --col_target "malware" \
    --test_size 0.1 \
    --output_train_path "data/train_trx.parquet" \
    --output_test_path "data/test_trx.parquet" \
    --output_test_ids_path "data/test_ids.csv" \
    --log_file "results/dataset_gender.log"

#  39 sec with    --print_dataset_info
#  21 sec without --print_dataset_info
