#!/bin/bash

# GPU allocation settings
GPUS=("0" "1" "2" "3" "4" "5" "6" "7")
NUM_GPUS=${#GPUS[@]}
PROCS_PER_GPU=1

# Base directories
DATA_DIR=""
OUTPUT_DIR=""
JSON_FILE=""

index=0
for category_dir in "$DATA_DIR"/*/; do
  category=$(basename "$category_dir")

  initializer_token=$(python3 -c "import json; print(json.load(open('$JSON_FILE')).get('$category', ''))")
  if [ -z "$initializer_token" ]; then
    echo "Skipping category $category - no initializer_token found"
    continue
  fi

  placeholder_token="<new_${category}>"
  output_dir="${OUTPUT_DIR}/${category}"

  gpu_index=$((index % NUM_GPUS))
  gpu=${GPUS[$gpu_index]}

  CUDA_VISIBLE_DEVICES=$gpu python textual_inversion.py \
    --pretrained_model_name_or_path="" \
    --train_data_dir="$category_dir" \
    --learnable_property="object" \
    --placeholder_token="$placeholder_token" \
    --initializer_token="$initializer_token" \
    --resolution=512 \
    --train_batch_size=1 \
    --gradient_accumulation_steps=4 \
    --max_train_steps=1 \
    --learning_rate=5.0e-04 \
    --scale_lr \
    --lr_scheduler="constant" \
    --lr_warmup_steps=0 \
    --output_dir="$output_dir" \
    --save_steps=200 &

  index=$((index + 1))

  if [ $((index % (NUM_GPUS * PROCS_PER_GPU)) -eq 0 ]; then
    wait
  fi
done

wait