import time
import hydra
import numpy as np

from plot import plot_gridworld

import logging

logger = logging.getLogger(__name__)


@hydra.main(config_path="config", config_name="main.yaml")
def main(cfg):
    np.random.seed(cfg.seed)
    env = hydra.utils.instantiate(cfg.env)
    algo = hydra.utils.instantiate(cfg.algo)
    algo.build(env)
    plot_gridworld(env, path="gridworld_novf.pdf")

    return_dict = algo.run()
    if cfg.plot:
        plot_gridworld(
            env,
            value_function=return_dict["vf"],
            policy=return_dict["policy"],
            path="gridworld.pdf",
        )

    np.savez("storage.npz", **return_dict)


if __name__ == "__main__":
    main()
