#include <iostream>
#include <vector>
#include <cmath>
#include <random>
#include <chrono>
#include <sstream>
#include <fstream>
using namespace std;

static std :: mt19937 gen(0);
void rng_seed(int seed_);

/*
Generates a random number between 0 and 1
*/
double unif();

/*
Generates a random number between 0 and n-1
*/
int unif_int(int n);

class SQVec
{
public:
    SQVec *left = NULL;  /* Pointer to left half of te array datastructure*/
    SQVec *right = NULL; /* Pointer to right half of the array datastructure*/
    int sign = 1;        /*If a leaf, then sign of the entry*/
    double norm_val = 0; /*square of the norm of the vector*/
    int index = -1;      /* If a leaf, then the index of the position it represents*/
    int size_val = 0;    /* The dimension of the vector*/
    int seed = 0;        /* Seed for random number generation*/
    double unif();       /* Generate a random number between 0 and 1*/

    SQVec();                                /*Constructor*/
    void build_util(vector<double> &arr, int l, int r); /*Utility function to build the tree*/
    void build(vector<double> &arr);                    /*Build the tree*/
    int size() const;                                   /*Return the size of the vector*/
    double norm2() const;                               /*Return the square of the norm of the vector*/
    double get(int i) const;                            /*Return the value at index i*/
    int sample();                                       /*Sample an index from the vector*/
    void update(int i, double val);                     /*Update the value at index i*/
    ~SQVec();                                           /*Destructor*/
};

class SQMat
{
public:
    SQVec *row_vec;      /*vector of row norms*/
    SQVec *rows;         /*vector of row vectors*/
    double norm_val = 0; /*square of the norm of the matrix*/

    SQMat();                     /*Constructor*/
    void build(vector<vector<double>> &arr); /*Build the matrix*/
    int size() const;                        /*Return the size of the matrix*/
    ~SQMat();                                /*Destructor*/
};

class SQCentre
{

public:
    SQMat *sqV;
    SQVec *sqc;
    double p;

    SQCentre(SQMat *V, SQVec *c);

    double bound_query(int i);

    double bound_sample();

    double get(int i);

    int sample();

    double unif();

    int unif_int(int n);
};





class SQCentres
{
    public : 
        SQMat* sqV;
        vector<int> indices;
        vector<double> probs;
        int k = 0;
        vector<SQCentre*> centres;
        discrete_distribution<int> dist ;

    SQCentres(SQMat* V, vector<int>& idxes) ;

    double get(int i);

    double bound_query(int i);

    double bound_sample();


    int sample() ;

    double unif();  

    

};

vector<int> QIkpp(SQMat* V, int k);
vector<int> kpp(vector<vector<double>>& data, int k);


vector<vector<double>> readDataFromFile(const std::string& filename) ;

double cost(vector<vector<double>>& data, vector<int> & indices);
double norm(vector<double>& x);

double dist(vector<double>& x, vector<double>& y);
