#include "qid2.h"
#include <iostream>

using namespace std;

double calc_variance(vector<double> &data)
{
    double mean = 0;
    for (int i = 0; i < data.size(); i++)
    {
        mean += data[i];
    }
    mean /= data.size();
    double variance = 0;
    for (int i = 0; i < data.size(); i++)
    {
        variance += (data[i] - mean) * (data[i] - mean);
    }
    variance /= data.size();
    return variance;
}



int main(int argc, char *argv[])
{

    srand(100);



    cout << "starting" << endl;

    string filename = argv[1];
    string output = argv[2];
    vector<vector<double>> data = readDataFromFile(filename);

          
    vector<int>K = {2,3,4,5,6,7,8,9,10};
    int rep = 10;
    SQMat* V = new SQMat();
    clock_t bstart = clock();
    V->build(data);
    clock_t bend = clock();
    double setup_time = (double)(bend - bstart) / CLOCKS_PER_SEC;   
    vector<double> sq_times;
    vector<double> sq_costs;
    vector<double> kpp_times;
    vector<double> kpp_costs;
    vector<double> sq_variances;
    vector<double> kpp_variances;


    for(auto k : K)
    {
        cout << "running for k = " << k << endl;

        double sq_cost = 0;
        double sq_time = 0;
        double kpp_cost = 0;
        double kpp_time = 0;


        vector<double> sq_costs_rep;
        vector<double> kpp_costs_rep;
        for(int i = 0; i < rep; i++)
        {
            int seed = rand();
            rng_seed(seed);
            clock_t start = clock();
            vector<int> indices = QIkpp(V, k);
            clock_t end = clock();
            sq_time += (double)(end - start) / CLOCKS_PER_SEC;
            double sq_temp =  cost(data, indices);
            sq_cost += sq_temp;

            clock_t kstart = clock();
            vector<int> kpp_indices = kpp(data, k);
            clock_t kend = clock();
            kpp_time += (double)(kend - kstart) / CLOCKS_PER_SEC;
            double kpp_temp = cost(data,kpp_indices);
            kpp_cost += kpp_temp;

            sq_costs_rep.push_back(sq_temp);
            kpp_costs_rep.push_back(kpp_temp);

        
        }


        sq_variances.push_back(calc_variance(sq_costs_rep));
        kpp_variances.push_back(calc_variance(kpp_costs_rep));
        sq_times.push_back(sq_time/rep);
        sq_costs.push_back(sq_cost/rep);
        kpp_times.push_back(kpp_time/rep);
        kpp_costs.push_back(kpp_cost/rep);
    }

    vector<double> cum_sq_times;
    vector<double> cum_kpp_times;
    double cum_sq_time = setup_time;
    double cum_kpp_time = 0;
    for(int i = 0; i < sq_times.size(); i++)
    {
        cum_sq_time += sq_times[i];
        cum_kpp_time += kpp_times[i];
        cum_sq_times.push_back(cum_sq_time);
        cum_kpp_times.push_back(cum_kpp_time);
    }

    ofstream out(output);
    out << "K, QIKPP Time, QIKPP Cost, KPP Time, KPP Cost" << endl;
    for(int i = 0; i < K.size(); i++)
    {
        out << K[i] << ", " << cum_sq_times[i] << ", " << sq_costs[i] << ", " << cum_kpp_times[i] << ", " << kpp_costs[i] << endl;
    }
    out<<endl;

    out << "K, QIKPP Variance, KPP Variance" << endl;
    for(int i = 0; i < K.size(); i++)
    {
        out << K[i] << ", " << sq_variances[i] << ", " << kpp_variances[i] << endl;
    }

}