
# Supplementary material of ICLR2026 submission number 16959

## Segmentation
- How to run code:

    - requirements
    '''txt
    pip install --upgrade pip
    pip install torch==1.10.0+cu113 torchvision==0.11.0+cu113 -f https://download.pytorch.org/whl/cu113/torch_stable.html 
    pip install tqdm six ordered_set numpy==1.21.2 opencv-python-headless==4.1.2.30 scipy==1.5.4
    pip install torch-pruning==1.3.5
    '''

    - download pretrained model
    '''txt
    cd /workspace/reproduce_neurips/IPPRO_seg
    mkdir pretrained_models
    cd pretrained_models
    wget https://github.com/LikeLy-Journey/SegmenTron/releases/download/v0.1.0/resnet50-25c4b509.pth
    '''

    - dataset
    '''txt
    you can download CityScape dataset on https://www.cityscapes-dataset.com/

    put your Cityscape dataset on '/workspace/' and name CityScape_dataset
    And you should change directory on mypath.py file
    '''

    1. run followings:
    '''sh
    
    sh /workspace/reproduce_neurips/IPPRO_seg/scripts/eval_flops70.sh  # DeeplabV3 FLOPs reduction of 70%
    sh /workspace/reproduce_neurips/IPPRO_seg/scripts/eval_flops80.sh  # DeeplabV3 FLOPs reduction of 80%
    '''

## Classification
- How to run code:
  
  - requirements
  ```txt
  torch == 1.13.0
  torchvision == 0.15.0
  torch-pruning == 1.3.5
  transformers == 4.46.3
  wget == 3.2
  datasts == 2.19.1
  ```

  - Our environment:
  docker image `nvcr.io/nvidia/pytorch:22.11-py3`

  - with Docker(recommanded):

    ```sh

    docker build -t neurips_21682 .

    docker run --rm --gpus all neurips_21682 # without imagenet evaluation

    docker run --rm --gpus all -v {your_local_imagenet_data_path}:/Imagenet -e IMAGENET_ROOT=/Imagenet neurips_21682

  
    ```

  - without docker:
  1. install requirements
  2. run followings:
  ```sh
  #automatically runs evaluation loop and print results
  python /workspace/reproduce_neurips/IPPRO_classification/bypass/core/main_imagenet.py # resnet50 on Imagenet


  ```


