#!/bin/bash/

GPU_NUM=1
NUM_WORKERS=4


DATASET='CS'
BALANCE=2
DATA_PARA='{"resample":true}'
MODEL_NAME='deeplabv3'
MODEL_PARA='{}'
BACKBONE='resnet50'
BACKBONE_PARA='{"os":8,"mg_unit":[1,2,4],"inplanes":128}'
INPUT_SIZE='769,769'
ALIGN_CORNER='True'
BS=8
TEST_BS=1
LOSS_TYPE='gsrl'
LOSS_PARA='{"ds_weight":0.4}'
OPTIM='sgd'
LEARNING_RATE=0.01
WEIGHT_DECAY=0.001


WHOLE='True'; MS='0.5,0.75,1,1.25,1.5,1.75'; FLIP='True'; PRUNE_RATIO='0.45,0.55,0.55,0.6,0.62,0.65,0.9'
INIT_PATH=/workspace/ICLR2026_submission_number16959/ICLR_deeplab_params/model_train_initial.pt
PARAM_PATH=/workspace/ICLR2026_submission_number16959/ICLR_deeplab_params/flops_reduction80_09_best.pth
python -m torch.distributed.launch --nproc_per_node=${GPU_NUM} evaluate_flops_iou.py --dataset ${DATASET} --model ${MODEL_NAME} --backbone ${BACKBONE} --score-path ${SCORE_PATH} --batch-size ${TEST_BS} --whole ${WHOLE} --flip ${FLIP} --input-size ${INPUT_SIZE} --align-corner ${ALIGN_CORNER} --ms ${MS} --prune-rate ${PRUNE_RATIO} --num-workers ${NUM_WORKERS} --restore-from ${PARAM_PATH} --init-path ${INIT_PATH} --save-predict 'FALSE' --channel-cfg ${CHANNEL_CFG}



