#include "InferStrategy.h"
#include "Simulation.h"
#include "ParticleFilter.h"
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/vector.hpp>
#include <boost/serialization/utility.hpp>




int main(int argc, char* argv[]) 
{
    std::cout <<"Inside main" <<std::endl;
    RInside R;


    std::vector<std::string> rats = {"rat103","rat106","rat112","rat113","rat114"};

    BS::thread_pool pool(18);
    std::cout << "Nb of threads in pool=" << pool.get_thread_count() << std::endl;

    //Run Dynamic Structure Learing (DSL) on rat data
    for(const std::string& ratName: rats)
    {
        std::string cmd = "load('/home/mattapattu/Projects/Rats-Credit/Sources/lib/InverseRL/"+ ratName +".Rdata')";
        R.parseEvalQ(cmd);                  
        Rcpp::S4 ratdata = R.parseEval("get('ratdata')");

        cmd = "load('/home/mattapattu/Projects/Rats-Credit/Sources/lib/TurnsNew/src/InverseRL/Hybrid3.Rdata')";
        R.parseEvalQ(cmd);                  
        Rcpp::S4 Optimal_Hybrid3 = R.parseEval("get('Hybrid3')"); 


        cmd = "load('/home/mattapattu/Projects/Rats-Credit/Sources/lib/TurnsNew/src/InverseRL/SubOptimalHybrid3.Rdata')";
        R.parseEvalQ(cmd);                  
        Rcpp::S4 Suboptimal_Hybrid3 = R.parseEval("get('SubOptimalHybrid3')"); 

        RatData rdata(ratdata);
        MazeGraph suboptimalHybrid3(Suboptimal_Hybrid3, false);
        MazeGraph optimalHybrid3(Optimal_Hybrid3, true);

        std::string rat = rdata.getRat();
        std::cout << "rat=" << rdata.getRat() << std::endl;
    
        //Stochastic Approximation EM to learn the RL agent structure parameters
        std::vector<double> params = SAEM(rdata, suboptimalHybrid3, optimalHybrid3, 30, pool);
        //Compute MAP of smoothed distribution to determine the RL agent structure in each session
        std::vector<int>inferred_seq =  stateEstimation(rdata, suboptimalHybrid3, optimalHybrid3, 30, params, 5, pool);

    }

    //After DSL is run on real data, validate by trying to recover RL agent structure from simulations
    for(const std::string& ratName: rats)
    {
        std::string cmd = "load('/home/mattapattu/Projects/Rats-Credit/Sources/lib/InverseRL/"+ ratName +".Rdata')";
        R.parseEvalQ(cmd);                  
        Rcpp::S4 ratdata = R.parseEval("get('ratdata')");

        cmd = "load('/home/mattapattu/Projects/Rats-Credit/Sources/lib/TurnsNew/src/InverseRL/Hybrid3.Rdata')";
        R.parseEvalQ(cmd);                  
        Rcpp::S4 Optimal_Hybrid3 = R.parseEval("get('Hybrid3')"); 


        cmd = "load('/home/mattapattu/Projects/Rats-Credit/Sources/lib/TurnsNew/src/InverseRL/SubOptimalHybrid3.Rdata')";
        R.parseEvalQ(cmd);                  
        Rcpp::S4 Suboptimal_Hybrid3 = R.parseEval("get('SubOptimalHybrid3')"); 

        RatData rdata(ratdata);
        MazeGraph suboptimalHybrid3(Suboptimal_Hybrid3, false);
        MazeGraph optimalHybrid3(Optimal_Hybrid3, true);

        std::cout << "rat=" << rdata.getRat() << ", starting testRecovery" << std::endl;

        testRecovery(rdata, suboptimalHybrid3, optimalHybrid3, R, "run1", pool);

    }

        

}
