% test an incremental gradient method on:
%   min 1/2*||Ax - b||^2 + mu/2*x'Dx
% where m < n, b = A*xo + sigma*noise
% The exact solution: xs = (A'A+mu*D)\A'b

% noise
sigma = .05; %sigma = input('sigma = ');
% if isempty(sigma), sigma = 0.05; end

n = 500*1;  % vector size
m = 5*round(n*0.2);
xo = linspace(-10,10,n)'; xo = 1./(1+exp(-xo)); % sigmoid
%xo = linspace(0,1,n)'; xo = exp(sin(8*pi*xo).*xo);

e = ones(n,1);
D = spdiags([-e 2*e -e],-1:1,n,n);
D(1,1) = 1; D(n,n) = 1;
%D = speye(n);

rng(0)
%A = sprandn(m,n,5/n,1e-5);
A = randn(m,n);
d = sqrt(sum(A.^2,2));
A = spdiags(1./d,0,m,m)*A;
%A = A/sqrt(m); % normalized
b = A*xo; noise = randn(m,1);
b = b + sigma*norm(b)/norm(noise)*noise;

mu = 0.2 ;
T1 = 10.^(-6:0); T2 = 1:.2:20;
T = [T1 T2];

Q = (A'*A + mu*D);
xs = Q \ (A'*b);
gres = @(x,r)norm(A'*r+mu*(D*x));
ferr = @(x,z)norm(x-z)/norm(z);

size_str = sprintf('\n[m,n] = [%i,%i] ',m,n);
simu_str = sprintf('sigma = %.2e mu = %.2e ',sigma,mu);
fprintf([size_str simu_str ' |xs-xo|: %6.2e\n\n'],ferr(xs,xo));
str = 't = %6.1e rho: %.4f |xt-xs|: %6.2e |g|: %6.2e |r|: %6.2e\n';

tn = numel(T);
Xt = zeros(n,tn);
rhos = zeros(tn,1);
errs = zeros(tn,1);
for i = 1:tn
    t = T(i);
    [xt,rho] = igd_exact(A,b,mu,D,t);
    Xt(:,i) = xt; 
    rhos(i) = rho; rt = A*xt-b;
    err = ferr(xt,xs); errs(i) = err; 
    fprintf(str,t,rho,err,gres(xt,rt),norm(rt)/norm(b));
    if rho > 1, break; end
end
idx = find(rhos > 1,1);
if ~isempty(idx) && idx>0, Xt = Xt(:,1:idx); T = T(1:idx); end

i = min(i,numel(T)); T = T(1:i); 
rhos = min(2,rhos(1:i)); errs = errs(1:i);

subplot(131)
plot(T,rhos,'linewidth',2); 
xlabel('t'), ylabel('\rho(K(t))')
title('Spectrum radius'); grid on;

subplot(132)
noise_level = ferr(xs,xo)*ones(size(T));
semilogy(T,errs,T,noise_level,'linewidth',2); 
xlabel('t'), ylabel('log||x(t)-x^*||')
title('Errors'); grid on;
legend('error(t)','noise level','location','best')



subplot(133)
plot(1:n,Xt(:,11),1:n,xs,1:n,xo,'linewidth',2);
legend('t=1.6','x*','x')
% xlabel(['(' sprintf('mu = %.2f',mu) ')']);
title('Computed solutions')
shg

% subplot(144)
% plot(1:n,Xt,1:n,xs,1:n,xo,'linewidth',2);
% legend('t','x*','x')
% % xlabel(['(' sprintf('mu = %.2f',mu) ')']);
% title('Computed solutions')
% shg

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [xt,rho,reg] = igd_exact(A,b,mu,D,t)
% 
[m,n] = size(A);

I = speye(n);
K0 = I - t*mu/m*D;

At = sqrt(t)*A'; 
b  = sqrt(t)*b;
K = eye(n);
c = zeros(n,1);

for i = 1:m
    ai = At(:,i);
    K = K0*K - ai*(ai'*K);
    c = K0*c - ai*(ai'*c);
    c = c + b(i)*ai;
end

xt = linsolve(I-K,c);
if nargout > 1
    %rho = norm(K);
    rho = abs(eigs(K,1,'largestabs','tol',1e-3));
end
if nargout > 2
    reg = .5*mu*(xt'*D*xt);
end
end