#!/bin/bash

seeds=(3831217417 1756129809 4075310593 2904435568 4115729820 2726071262 1865059290 1408779145 3716099507 411100252)
if [ -z "$envs" ];
then
  envs=(HalfCheetah-v4 Ant-v4 Hopper-v4 Walker2d-v4 Swimmer-v4)
fi

for env_id in ${envs[*]}; do
  for seed in ${seeds[*]}; do
    CUDA_VISIBLE_DEVICES= OMP_NUM_THREADS=1 python train.py --algo ars --env $env_id --seed $seed \
   --eval-freq 25000 --verbose 0 --n-eval-envs 5 --eval-episodes 20 \
   --log-interval 100 -c hyperparams/ars.yaml -P
  done
done