#!/bin/bash

if [ -z "$envs" ];
then
  envs=(HalfCheetah-v4 Ant-v4 Hopper-v4 Walker2d-v4 Swimmer-v4)
fi

if [ -z "$seeds" ];
then
  seeds=(1 2 3 4 5 6 7 8 9 10)
fi

for env_id in ${envs[*]}; do
  for seed in ${seeds[*]}; do
    echo "==== logs/open_loop/${env_id}_${seed} ===="
    # Print best trial
    optuna best-trial --storage logs/open_loop/${env_id}_${seed}/storage.log \
    --study-name ${env_id} -f yaml
    echo -e "===========================================\n"
  done
done
