# RNNLogic Toy

This is a toy implementation of RNNLogic to better illustrate the EM optimization algorithm.

The toy implementation is written in C++, where integrating with the PyTorch LSTM rule generator is not straightforward, so we replace the LSTM rule generator with a rule generator parameterized by a lookup table. The result obtained in this way is slightly worse than the result of the LSTM rule generator, but it is better for illustration purpose.

To compile the toy implementation, please use the following command:

g++ -O3 RNNLogic.h main.cpp -o rnnlogic -lpthread -lgsl -lgslcblas

To run the toy implementation on the Kinship and UMLS datasets, please use the following command:

./rnnlogic -data-path kinship -max-length 3 -threads 10 -threshold 0 -support 1 -lr 0.01 -wd 0.0005 -temp 100 -iterations 5 -top-n 2000 -top-k 100 -top-n-test 100

./rnnlogic -data-path umls -max-length 3 -threads 10 -threshold 0 -support 1 -lr 0.01 -wd 0.0005 -temp 100 -iterations 5 -top-n 2000 -top-k 100 -top-n-test 100

As other datasets are much larger, we only provide the Kinship and UMLS datasets here.
