import logging
from models.classifier import Classifier
from models.img_resnet import ResNet50
from models.Discriminator import Discriminator
from models.genertor import DouGen

def build_model(config, num_identities, num_clothes):
    logger = logging.getLogger('reid.model')
    # Build backbone
    logger.info("Initializing model: Resnet50, model2: HPM")
    model = ResNet50(config, num_clothes)
    discriminator = Discriminator(feature_dim=config.MODEL.FEATURE_DIM)
    genertor = DouGen()
    logger.info("Model  size: {:.5f}M".format(sum(p.numel() for p in model.parameters())/1000000.0))
    # Build classifier
    identity_classifier = Classifier(feature_dim=config.MODEL.FEATURE_DIM, num_classes=num_identities)
    return model, identity_classifier, discriminator, genertor