function [U,err] = UU_factorization_visualize(A,AT,b,U0,ss,maxit)
%UU_FACTORIZATION_PSD for least squares problem
%   Inputs: 
%   - A: handle for the linear measurement map
%   - AT: handle for the adjoint of the measurement map
%   - b: observations
%   - U0: initial estimate for U
%   - ss: stepsize
%   - maxit: number of iterations
%   Outputs:
%   - U: factor U
%   - err: convergence error (least-squares)

U = U0;
err = nan(maxit,1);

hfig = figure('Position',[100,100,900,1200]);
set(hfig,'name','uu_normsu_noisy','numbertitle','off');
kk = 0;

for t = 1:maxit
    U_old = U;
    X = U*U';
    AXb = A(X) - b;
    err(t) = norm(AXb)^2;
    AtXb = AT(AXb);
    grad = (AtXb+AtXb')*U;
    U = U - ss*grad; 
    
    % if norm(U-U_old,'fro') < 1e-12
    %     err(t+1:end) = [];
    %     break;
    % end

    if any(t == [25,50,75,100,250,500,750,1000,2500,5000,7500,10000,25000,50000,75000,100000,250000,500000,750000,1000000])
        kk = kk+1;
        normU = norms(U,[],1);
        subplot(4,4,kk)
        plot(normU)
        ylim([0,1])
        title(['k = ',num2str(t)])
        drawnow
    end


end

end

