# Setup Environment
You can use the bash file to create the conda environment:

`bash ./prepare_env.sh`

Then activate the env:

`conda activate pgkd`

(By default, the torch and dgl are cpu-version, and you can install the GPU version (torch 1.12.0 + dgl 1.0.1+cu102). The results in paper are based on GPU version.)

# Preparing Datasets

We provide the datasets as attachment files. 

For more, please refer to https://github.com/snap-research/graphless-neural-networks.

# Training

To train a teacher:

`bash bash/train_teacher.sh`

Then train a student using PGKD:

`bash bash/student_cora.sh`

For the hyper-parameters:
```
setting=tran/ind # transductive or inductive

teacher=GAT/SAGE/GCN # GNN types for teachers

dataset=cora/citeseer # datasets to use

type=CRD/KD  # [CRD] means PGKD and [KD] means vanilla KD
```

And the results can be found in:
`outputs/transductive/cora/SAGE_XXX/exp_results`

XXX could be none(for teacher outputs), MLP_KD (for vanilla KD outputs) and MLP_CKD (for PGKD outputs).
