# FINDE: Neural Differential Equations for Finding and Preserving Invariant Quantities

Many real-world dynamical systems are associated with first integrals (a.k.a. invariant quantities), which are quantities that remain unchanged over time. The discovery and understanding of first integrals are fundamental and important topics both in the natural sciences and in industrial applications. First integrals arise from the conservation laws of system energy, momentum, and mass, and from constraints on states; these are typically related to specific geometric structures of the governing equations. Existing neural networks designed to ensure such first integrals have shown excellent accuracy in modeling from data. However, these models incorporate the underlying structures, and in most situations where neural networks learn unknown systems, these structures are also unknown. This limitation needs to be overcome for scientific discovery and modeling of unknown systems. To this end, we propose first integral-preserving neural differential equation (FINDE). By leveraging the projection method and the discrete gradient method, FINDE finds and preserves first integrals from data, even in the absence of prior knowledge about underlying structures. Experimental results demonstrate that FINDE can predict future states of target systems much longer and find various quantities consistent with well-known first integrals in a unified manner.

## Requirements

- Python v3.8.12
- scipy v1.7.3,
- pytorch v1.10.2
- torchdiffeq v0.1.1
- functorch v1.10 preview

The codes were made by modifying the codes taken from [Hamiltonian neural networks](https://github.com/greydanus/hamiltonian-nn) and [DGNet](https://github.com/tksmatsubara/discrete-autograd).

## Other environments

- OS: Ubuntu 20.04
- Random seeds: 0-4

## Training and Evaluation

Commands to reproduce results:

```sh
python train_ode.py --name 2body          --model hnn    --norm --total_steps 100000 --finde continuous    --finde_num 2 --seed 0 --verbose
python train_pde.py --name KdV            --model cnn    --norm --total_steps 30000  --finde continuousPDE --finde_num 3 --seed 0 --verbose
python train_ode.py --name 2pend          --model sonode --norm --total_steps 100000 --finde continuous    --finde_num 5 --seed 0 --verbose
python train_ode.py --name FitzHughNagumo --model node   --norm --total_steps 30000  --finde continuous    --finde_num 2 --seed 0 --verbose
```

- `--name`: dataset. Choose one from 2body, 2pend, FitzHughNagumo, and KdV.
- `--model`: base model. Choose one from hnn, node, sonode, and others.
- `--seed`: random seed.
- `--total_steps`: number of iterations.
- `--adjoint`: use adjoint method for PDEs.
- `--norm`: data normalization at the first layer.
- `--finde`: use FINDE. Choose one from continuous, discrete, continuousPDE, and discretePDE.
- `--finde_num`: number of first integrals. K in the manuscript.
