import pickle

def L2_loss(u, v):
    return (u - v).pow(2).mean()


def to_pickle(thing, path):  # save something
    with open(path, 'wb') as handle:
        pickle.dump(thing, handle, protocol=pickle.HIGHEST_PROTOCOL)


def from_pickle(path):  # load something
    thing = None
    with open(path, 'rb') as handle:
        thing = pickle.load(handle)
    return thing

class DotDict(dict):
    def __init__(self, **arg):
      super(DotDict, self).__init__(**arg)
    def __getattr__(self, k):
      return self.get(k)
    def __setattr__(self, k, v):
      self.__setitem__(k, v)
