#!/bin/bash
#SBATCH --time=1-24:00:00
#SBATCH --ntasks=1
#SBATCH --mem=40G
#SBATCH --gres=gpu:A6000:1
#SBATCH --job-name=benchmark_model
#SBATCH --output=logs/benchmark_model_%A_%a.log   # Log file for each task
#SBATCH --error=logs/benchmark_model_error_%A_%a.log     # Error log file for each task


# Declare arrays correctly
models=('/data/llm_weights/soft_mem/unlearning_vs_safety/cais_Zephyr_RMU/relearn_wmdp_bio-retain-corpus_5' 
        '/data/llm_weights/soft_mem/unlearning_vs_safety/cais_Zephyr_RMU/relearn_wmdp_bio-retain-corpus_10'
        '/data/llm_weights/soft_mem/unlearning_vs_safety/cais_Zephyr_RMU/relearn_wmdp_bio-retain-corpus_50'
        '/data/llm_weights/soft_mem/unlearning_vs_safety/J4Q8_zephyr-npo-bio/relearn_wmdp_bio-retain-corpus_5'
        '/data/llm_weights/soft_mem/unlearning_vs_safety/J4Q8_zephyr-npo-bio/relearn_wmdp_bio-retain-corpus_10'
        '/data/llm_weights/soft_mem/unlearning_vs_safety/J4Q8_zephyr-npo-bio/relearn_wmdp_bio-retain-corpus_50'
        "HuggingFaceH4/zephyr-7b-beta" 
        "cais/Zephyr_RMU" 
        'J4Q8/zephyr-npo-bio'
)

tasks=("wmdp-bio")
# Iterate over models and tasks
for model in "${models[@]}"; do
    for task in "${tasks[@]}"; do
        # Run first benchmark command
        python -m src.benchmarking.benchmark \
            --model_name_or_path "$model" \
            --tasks "$task" \
            --wandb_project "benchmarking" \
            --wandb_tags "relearn_attack" \
            --tokenizer_name_or_path "HuggingFaceH4/zephyr-7b-beta"
    done
done
