#!/usr/bin/env python3
#coding: utf-8

import base64
import datetime
import hashlib
import hmac
import os
import uuid
import json
import time

import requests
from loguru import logger


HOST = "http://trpc-gpt-eval.production.polaris:8080"
API_VERSION = "v2.03"
MODEL_DOUBAO_1_5 = "api_doubao_Doubao-1.5-pro-32k-250115"
MODEL_DOUBAO_DS_R1 = "api_doubao_DeepSeek-R1-250120"
MODEL_DOUBAO_DS_V3 = "api_doubao_DeepSeek-V3-241226"
MODEL_ALI_QWEN_MAX = "api_text2text_ali_qwen-max"         


def get_simple_auth(source, app_id, app_key):
    date_time = datetime.datetime.utcnow().strftime("%a, %d %b %Y %H:%M:%S GMT")
    auth = (
        'hmac id="'
        + app_id
        + '", algorithm="hmac-sha1", headers="date source", signature="'
    )
    sign_str = "date: " + date_time + "\n" + "source: " + source
    sign = hmac.new(app_key.encode(), sign_str.encode(), hashlib.sha1).digest()
    sign = base64.b64encode(sign).decode()
    sign = auth + sign + '"'
    return sign, date_time

class Api():
    def __init__(
        self,
        api_id="",
        apikey="",
        model=MODEL_DOUBAO_DS_V3,
        system_prompt: str = "",
        host=HOST,
    ):
        if api_id == "":
            api_id = os.getenv("EVA_API_ID", "nXAKgkaS_neiljkguo")
        assert api_id != "", "empty eva api id"
        if apikey == "":
            apikey = os.getenv("EVA_API_KEY", "yWSdfb8M52bRBdhn")
        assert apikey != "", "empty eva api key"
        logger.warning(f"init eva api: {api_id}, apikey:{apikey}")

        self.user = api_id
        self.apikey = apikey
        self.model = model
        self.host = host
        self.system_prompt = system_prompt
        self.timeout = 3600

    def _get_header(self):
        source = "neo"
        sign, date_time = get_simple_auth(source, self.user, self.apikey)
        headers = {
            "Apiversion": API_VERSION,
            "Authorization": sign,
            "Date": date_time,
            "Source": source,
        }
        return headers

    def chat(self, msg: str,mode) -> str:
        outputs = self._request(msg,mode)
        return outputs

    def _request(self, msg, mode) -> str:
        base_url = self.host + "/api/v1/data_eval"
        params = {}
        if msg[0]['role'] == 'system':
            system_prompt = msg[0]['content'][0]['value']
            msg = msg[1:]
        else:
            system_prompt = self.system_prompt
        data = {
            "request_id": str(uuid.uuid4()),
            "model_marker": self.model,
            "system": system_prompt,
            "temperature":0.2,
            "messages": msg,
            "params": params,
            "timeout": 600,
        }

        headers = dict(self._get_header())
        content = ""
        try:
            response = requests.post(
                url=base_url, headers=headers, json=data, timeout=self.timeout
            )
            ret = response.json()

            for elem in ret['answer']:
                if elem['type'] == 'text':
                    content = elem['value']
            total_tokens = [ret['cost_info']['prompt_tokens'], ret['cost_info']['completion_tokens'], ret['cost_info']['total_tokens']]
        except Exception as e:  # pylint: disable=broad-except
            logger.exception(f"fail: query:{data}\nerror:{e},\nret:{ret}")
            time.sleep(3)

        return {"content": content, "usage": total_tokens}


def call_geminipro(messages):
    model_id = 'api_google_gemini-2.5-pro'
    api = Api(model=model_id)
    while True:
        try:
            outputs= api.chat(messages, "nothink")
            # print("\n"+ret_msg)
            return outputs
        except Exception as e:
            print("try gain")
            time.sleep(3)
