# -*- coding: utf-8 -*-

import time
import argparse
import pandas as pd
import requests
import json
from concurrent.futures import ThreadPoolExecutor, as_completed
import threading

write_lock = threading.Lock()


class HunYuan:
    def __init__(self, model_name="hunyuan-turbos-latest"):
        self.model_name = model_name

    def __call__(self, messages, **kwargs):
        return self.call_model_hunyuan(messages, self.model_name)

    @staticmethod
    def call_model_hunyuan(messages, model="hunyuan-turbos-latest"):
        request_data = {"messages": messages,
                        "stream": False,
                        "top_k": 1,
                        "enable_enhancement": False,
                        "model": model,
                        "query_id": "123"}
        headers = {"Content-Type": 'application/json',
                   "Authorization": 'Bearer YOUR TOKEN HERE'}
        hunyuan_url = "http://hunyuanapi.woa.com/openapi/v1/chat/completions"
        count = 0
        while True:
            try:
                count += 1
                response = requests.post(hunyuan_url, json=request_data, headers=headers)
                # print("output json", response.json())
                response = response.json()
                response_content = response["choices"][0]["message"]["content"]
                print(response)
                usage = [response['usage']['prompt_tokens'], response['usage']['completion_tokens'], response['usage']['total_tokens']]
                return {"content": response_content, "usage": usage, "cost": 0}
            except Exception as e:
                print('hunyuan server Exception: ', e)
                if count > 100:
                    response_content = ""
                    return response_content
