#!/usr/bin/env python3
#coding: utf-8

# Author: Zhaopeng Tu
# Date: 2025-04-22
# Function: Use a uniformAPI for all models, Anping is All You Need!

import os, sys, time
from datetime import datetime
from colorama import Fore, Back, Style, init
import uuid
import json
import requests
import base64

import hashlib
import hmac
from loguru import logger

# model list
o3_pro = "api_openai_o3-pro-2025-06-10"
o3 = "api_azure_openai_o3"
chatgpt_4o_latest = "api_openai_chatgpt-4o-latest"

gemini2_5_pro = "api_google_gemini-2.5-pro"
gemini2_5_flash = "api_google_gemini-2.5-flash"

claude4_opus  = "api_aws_anthropic.claude-opus-4-20250514-v1:0"
claude4_sonnet = "api_aws_anthropic.claude-sonnet-4-20250514-v1:0"

r1 = "api_doubao_DeepSeek-R1-250528"
v3 = "api_doubao_deepseek-v3-250324"

grok4 = "api_xai_grok-4-latest"
grok3 = "api_xai_grok-3-latest"

hybrid_mode = False

MAX_RETRY = 10

def duzzy_mapping_private_model(model):
    # if 'v3' in model.lower():
    #     return v3
    # elif 'r1' in model.lower():
    #     return r1
    if 'v3.1' in model.lower():
        # print('=='*1000)
        return 'api_doubao_DeepSeek-V3.1-250821'
    if 'api_ali_qwen3-max-preview'  in model.lower():
        return 'api_ali_qwen3-max-preview'
    if 'api_google_gemini-2.5-pro' in model.lower():
        return 'api_google_gemini-2.5-pro'
    if 'api_openai_gpt-5-chat-latest' == model.lower():
        return 'api_openai_gpt-5-chat-latest'
    if 'api_openai_gpt-5' == model.lower():
        return 'api_openai_gpt-5'
    if 'api_anthropic_claude-opus-4-1-20250805' in model.lower():
        return 'api_anthropic_claude-opus-4-1-20250805'
    if 'grok-4' in model.lower() and 'latest' in model.lower():
        return grok4
    if 'grok-3' in model.lower() and 'latest' in model.lower():
        raise ValueError(f"model {model} deprecated")
    if 'api_xai_grok-4-0709' in model.lower():
        return 'api_xai_grok-4-0709'
    if 'api_azure_openai_gpt-4.1' in model.lower():
        return 'api_azure_openai_gpt-4.1'
    if 'o3-pro' in model.lower():
        return o3_pro
    if 'chatgpt-4o' in model.lower():
        return chatgpt_4o_latest
    elif 'o3' in model.lower() and 'pro' not in model.lower():
        return o3
    if 'gemini' in model.lower():
        if 'flash' in model.lower():
            return 'api_google_gemini-2.5-flash'
        elif 'pro' in model.lower():
            return 'api_google_gemini-2.5-pro'
    if 'opus' in model.lower() and '20250514' in model.lower():
        return claude4_opus
    if 'sonnet' in model.lower() and '20250514' in model.lower():
        return claude4_sonnet
    if 'api_openai_chatgpt-4o-latest' in model.lower():
        return chatgpt_4o_latest
    if 'api_azure_openai_gpt-4.5-preview' in model.lower():
        return 'api_azure_openai_gpt-4.5-preview'
    if 'api_moonshot_kimi-k2-0711-preview' in model.lower():
        return 'api_moonshot_kimi-k2-0711-preview'
    if 'api_azure_openai_gpt-5' in model.lower():
        return 'api_azure_openai_gpt-5'
    if 'api_azure_openai_gpt-5-chat-latest' in model.lower():
        return 'api_azure_openai_gpt-5-chat-latest'
    if 'api_google_gemini-2.5-flash' in model.lower():
        return 'api_google_gemini-2.5-flash'
    if 'api_azure_openai_o4-mini' in model.lower():
        return 'api_azure_openai_o4-mini'
    if 'api_openai_gpt-4.5-preview' in model.lower():
        return 'api_openai_gpt-4.5-preview'
    return None


def get_anping_result(messages, model, params={}):
    # authorization
    model = duzzy_mapping_private_model(model)
    # print(f"model: {model}")
    assert model is not None
    # app_id = "xrLN3S5f_zptu"
    # app_key = "qjGTqsyOFU6J3RPi"
    # source = "zptu"  # 签名水印值，可填写任意值

    app_id = '9sFaJSkP_mangoshi'
    app_key = 'DU5JQXp4RfR8vorW'
    source = "shizhl"  # 签名水印值，可填写任意值
    date_time = datetime.utcnow().strftime("%a, %d %b %Y %H:%M:%S GMT")
    auth = (
        'hmac id="'
        + app_id
        + '", algorithm="hmac-sha1", headers="date source", signature="'
    )
    sign_str = "date: " + date_time + "\n" + "source: " + source
    sign = hmac.new(app_key.encode(), sign_str.encode(), hashlib.sha1).digest()
    sign = base64.b64encode(sign).decode()
    sign = auth + sign + '"'
    print('===' * 100)
    headers = {
        "Apiversion": "v2.03",
        "Authorization": sign,
        "Date": date_time,
        "Source": source,    # 签名水印值，可填写任意值
    }

    # call api
    base_url = "http://trpc-gpt-eval.production.polaris:8080/api/v1/data_eval"

    request_id = str(uuid.uuid4())
    # print('Request: ', request_id)

    prompt = messages[0]['content'][0]['value'] if messages[0]['role'] == 'system' else ""
    data = {
        # "request_id": str(uuid.uuid4()),
        "request_id": request_id,
        "model_marker": model,
        "system": prompt,
        "messages": messages,
        # "stream": True,
        # "messages": [
        #     {
        #         "role": "user",
        #         "content": [
        #             {
        #                 "type": "text",
        #                 "value": query,
        #             }
        #         ],
        #     }
        # ],
        "params": params,
        "timeout": 3600,
        "thinking": {
            "type": "enabled",
            "budget_tokens": 10000
        },
    }

    content = ""
    total_tokens = 0
    cnt = 0
    while cnt < MAX_RETRY:
        try:
            response = requests.post(
                url=base_url, headers=headers, json=data
            )
            ret = response.json()
            # print(json.dumps(ret, indent=4, ensure_ascii=False))
            for elem in ret['answer']:
                if elem['type'] == 'reasoning':
                    content = elem['value']
                    print(Style.BRIGHT + Fore.YELLOW + '开始思考')
                    print(Fore.YELLOW + content)
                    print(Style.BRIGHT + Fore.YELLOW + '结束思考')
        
                elif elem['type'] == 'text':

                    content = elem['value']
            '''
            {'prompt_tokens': 376, 'completion_tokens': 1518, 'total_tokens': 1894, 'cost': 515840}
            '''
            total_tokens = ret['cost_info']
            total_tokens['cost'] = total_tokens['cost'] / 1000000.0
            time.sleep(5)
            return {"content": content, "usage": [total_tokens['prompt_tokens'], total_tokens['completion_tokens'], total_tokens['total_tokens']], "cost": total_tokens['cost']}
        except Exception as e:  # pylint: disable=broad-except
            logger.exception(f"Retry {cnt}\n error:{e}")
            time.sleep(30)
        cnt+=1

if __name__ == "__main__":
    query = "你好"
    # model = grok4
    # model = 'api_anthropic_claude-opus-4-1-20250805' 
    # model = 'api_openai_chatgpt-4o-latest' 
    # model = 'api_azure_openai_gpt-4.5-preview'
    # model = 'gemini-2.5-flash'
    # model = 'api_moonshot_kimi-k2-0711-preview'
    # model = 'api_azure_openai_gpt-5'
    # model = 'api_azure_openai_gpt-5-chat-latest'
    # model = 'api_anthropic_claude-opus-4-20250514'
    # model = 'api_azure_openai_o3'
    # model = 'api_aws_anthropic.claude-opus-4-20250514-v1:0'
    # model = 'api_xai_grok-4-0709'
    # model = 'api_openai_gpt-5'
    # model = 'api_openai_gpt-5-chat-latest'
    # model = 'api_azure_openai_gpt-4.1'
    # model = claude4_opus
    # model = 'api_openai_chatgpt-4o-latest'
    # model = 'api_google_gemini-2.5-flash'
    # model = 'api_azure_openai_o4-mini'
    # model = 'api_openai_gpt-4.5-preview'
    # model = 'api_google_claude-opus-4@20250514'
    model = 'api_aws_anthropic.claude-sonnet-4-20250514-v1:0'
    messages = [
        # {"role": "system", "content": [{"type": "text", "value": "You are a helpful assistant."}]},
        {"role": "user", "content": [{"type": "text", "value": query}]},
    #    {"role": "user", "content": "Hello, world"}
    ]
    response = get_anping_result(messages=messages, model=model)
    print(response['content'])
    print(response['usage'])
    print(response['cost'])
