import numpy as np


def convert_seconds_to_dhms(seconds):
    days = seconds // (24 * 3600)
    seconds = seconds % (24 * 3600)
    hours = seconds // 3600
    seconds %= 3600
    minutes = seconds // 60
    seconds %= 60
    return int(days), int(hours), int(minutes), seconds


def apply_reverse(arr, reverse):
    return arr[::-1] if reverse else arr


def create_entry(mean_func, mask, reverse):
    return {
        "argsrt": apply_reverse(mean_func().argsort(), reverse),
        "perf": [],
        "mask": mask,
    }


def create_mean_func(data, mask=None):
    if mask is not None:
        return lambda: data[mask].mean(0)
    return lambda: data.mean(0)


def create_sub_mean_func(data, mask=None):
    if mask is not None:
        return lambda: np.nanmean(data[mask], axis=0)
    return lambda: np.nanmean(data, axis=0)


def initialize_dict_results(
    approaches,
    margins_suffixes,
    sub_margins_suffixes,
    accs_suffixes,
    sub_accs_suffixes,
    test_mask,
    val_mask,
    eval_mask,
    reverse,
    rnd,
    degree,
):
    results_dict = {}

    for key, (
        margins,
        sub_margins,
        test_accs,
        val_accs,
        sub_test_accs,
        sub_val_accs,
    ) in approaches.items():
        results_dict[f"{key}_{margins_suffixes[0]}"] = create_entry(
            mean_func=create_mean_func(margins), mask=eval_mask, reverse=reverse
        )
        results_dict[f"{key}_{margins_suffixes[1]}"] = create_entry(
            mean_func=create_mean_func(margins, test_mask),
            mask=eval_mask,
            reverse=reverse,
        )
        results_dict[f"{key}_{margins_suffixes[2]}"] = create_entry(
            mean_func=create_mean_func(margins, val_mask),
            mask=eval_mask,
            reverse=reverse,
        )

        results_dict[f"{key}_{sub_margins_suffixes[0]}"] = create_entry(
            mean_func=create_sub_mean_func(sub_margins), mask=eval_mask, reverse=reverse
        )
        results_dict[f"{key}_{sub_margins_suffixes[1]}"] = create_entry(
            mean_func=create_sub_mean_func(sub_margins, test_mask),
            mask=eval_mask,
            reverse=reverse,
        )
        results_dict[f"{key}_{sub_margins_suffixes[2]}"] = create_entry(
            mean_func=create_sub_mean_func(sub_margins, val_mask),
            mask=eval_mask,
            reverse=reverse,
        )

        results_dict[f"{key}_{accs_suffixes[0]}"] = create_entry(
            mean_func=lambda: test_accs, mask=eval_mask, reverse=reverse
        )
        results_dict[f"{key}_{accs_suffixes[1]}"] = create_entry(
            mean_func=lambda: val_accs, mask=eval_mask, reverse=reverse
        )

        results_dict[f"{key}_{sub_accs_suffixes[0]}"] = create_entry(
            mean_func=lambda: sub_test_accs, mask=eval_mask, reverse=reverse
        )
        results_dict[f"{key}_{sub_accs_suffixes[1]}"] = create_entry(
            mean_func=lambda: sub_val_accs, mask=eval_mask, reverse=reverse
        )

    # Adding random and degree entries
    results_dict["rnd_perf"] = {
        "argsrt": rnd,
        "perf": [],
        "mask": eval_mask,
    }

    results_dict["degree"] = {
        "argsrt": apply_reverse(
            degree.numpy().argsort(),
            reverse,
        ),
        "perf": [],
        "mask": eval_mask,
    }

    return results_dict
