def get_keywords(node, features, idx_to_attr, top_k):
    frequent_words = features.argsort(dim=1)[node].tolist()[-top_k:][::-1]
    keywords = [idx_to_attr[idx] for idx in frequent_words]
    return keywords


def find_common_keywords(u, v, features, idx_to_attr, top_k):
    keywords_u = get_keywords(u, features, idx_to_attr, top_k)
    keywords_v = get_keywords(v, features, idx_to_attr, top_k)
    return list(set(keywords_u) & set(keywords_v))
