# Geometry-Aware Convolutional Neural Networks
Here, we provide a step-by-step guid on how to obtain the results in the paper using the provided code.

## Setting up the environment
Unzip the supplementary materials zip file.

    unzip supplementary.zip

Go to the directory containing this **README** file.

    cd supplementary

Create a Conda environment.

    conda create -n geo_conv python==3.9.16

Install the required libraries.

    pip install -r requirements.txt

---
## Evaluation
To obtain the tables (and figures) in the paper, you can execute the following commands. The tables (and figures) for each experiment are saved *in a folder named after that experiment* in the `results/` directory.

To run the VAE and GAN experiments, you need to:

1- Download the [**CelebA_hq** dataset from Kaggle](https://www.kaggle.com/datasets/lamsimon/celebahq), save it in the `resources/` directory inside the project's root directory, and name it as `celebahq.zip`. Therefore, the address of the file from the project's root will be `resources/celebahq.zip`.

2 - Download the [**Hand Gesture** dataset from Massey University website](https://www.massey.ac.nz/~albarcza/gesture_dataset2012.html). It consists of 5 parts. Inside the `resources/` folder, create a subfolder named 'gesture_2012'. Inside 'gesture_2012', create 5 subfolders with names: 'part_1', 'part_2', 'part_3', 'part_4', 'part_5'. Copy the content of each downloaded section of the dataset to the corresponding subfolder. Therefore, the address of the subfolder including the images of the first section from project's root will be `resources/gesture_2012/part_1/`.

The other dataset we use in our experiments is **CelebA**. It is automatically downloaded by the code so you do not need to download the dataset locally yourself.


### The Deep Convolutional Generative Adversarial Networks (DCGAN) experiment on CelebA_hq 
To run this experiment run the following command in the project's root directory.

    python3 evaluation/gan/celeba_hq/train_dcgan.py

When the execution is complete, the results will be saved in `results/gan/`.

### The Wasserstein Generative Adversarial Networks with Gradient Penalty (WGAN-GP) experiment on CelebA_hq 
To run this experiment run the following command in the project's root directory.

    python3 evaluation/gan/celeba_hq/train_wgan-gp.py

When the execution is complete, the results will be saved in `results/wgan/`.

### The Wasserstein Generative Adversarial Networks with Gradient Penalty (WGAN-GP) experiment on Hand Gesture 
To run this experiment run the following command in the project's root directory.

    python3 evaluation/gan/gesture_2012/train_cwgan-gp.py

When the execution is complete, the results will be saved in `results/cwgan/`.

### The Variational AutoEncoder (VAE) experiment on CelebA
To run this experiment run the following command in the project's root directory.

    python3 evaluation/cvae/celeb_a/train_cvae.py

When the execution is complete, the results will be saved in `results/cvae/celeb_a/`.

---

## Appendix

### The mass centre experiment
To run this experiment run the following command in the project's root directory.

    python3 evaluation/mass_centre/mass_centre.py

When the execution is complete, the results will be saved in `results/mass_centre/`.

### Positional Bias
To run the experiment that demonstrate the positional bias problem in `CoordConv`, run

    python3 evaluation/positional_bias/positional_bias.py

When the execution is complete, the results will be saved in `results/positional_bias/`.

### The Variational AutoEncoder (VAE) experiment on Hand Gesture
To run this experiment run the following command in the project's root directory.

    python3 evaluation/gesture_2012/celeb_a/train_cvae.py

When the execution is complete, the results will be saved in `results/cvae/gesture_2012/`.

