"""This module downloads the celeba_hq dataset from Kaggle.
This dataset includes 1024*1024 images, divided into a
training and a validation set."""

import os
import zipfile
import random

def create_celeba_hq(keep_tarballs=True, seed=0):
    CELEBA_HQ_ZIP = "resources/celebahq.zip"
    CELEBA_HQ_DIR = "resources/celeba_hq/"
    CELEBA_HQ_TRAIN_DIR = CELEBA_HQ_DIR + "train/"
    CELEBA_HQ_VAL_DIR = CELEBA_HQ_DIR + "val/"

    if not os.path.isdir(CELEBA_HQ_TRAIN_DIR):
        # os.system("cd resources/ && %s && kaggle datasets download -d lamsimon/celebahq" % activate_env_cmd)
        os.makedirs(CELEBA_HQ_DIR, exist_ok=True)

        with zipfile.ZipFile(CELEBA_HQ_ZIP) as zip_f:
            zip_f.extractall('resources/')

            # set random seed for reproducibility
            random.seed(seed)
            # create a list of 1500 random numbers between 1 and 30000
            randomlist = random.sample(range(1, 30000), 1500)
            # convert the random list to strings of 5 digits
            randomlist_str = [str(i).zfill(5) for i in randomlist]

            os.makedirs(CELEBA_HQ_TRAIN_DIR, exist_ok=True)
            os.makedirs(CELEBA_HQ_TRAIN_DIR + "train/", exist_ok=True)

            os.makedirs(CELEBA_HQ_VAL_DIR, exist_ok=True)
            os.makedirs(CELEBA_HQ_VAL_DIR + "val/", exist_ok=True)

            # move the images with their index available in randomlist_str to the validation directory
            for index_str in randomlist_str:
                os.rename(CELEBA_HQ_DIR + index_str + ".jpg", CELEBA_HQ_VAL_DIR + "val/" + index_str + ".jpg")

            # move the remaining images in CELEBA_HQ_DIR to the training directory
            for filename in os.listdir(CELEBA_HQ_DIR):
                if filename.endswith(".jpg"):
                    os.rename(CELEBA_HQ_DIR + filename, CELEBA_HQ_TRAIN_DIR + "train/" + filename)

    if not keep_tarballs:
        try:
            os.remove(CELEBA_HQ_ZIP)
        except FileNotFoundError:
            pass


    CELEBA_HQ_DIRS = {
        "train": CELEBA_HQ_TRAIN_DIR,
        "val": CELEBA_HQ_VAL_DIR
    }

    return CELEBA_HQ_DIRS
