import numpy as np


def mass_centre_dataset(num_imgs,
                        length,
                        pts_ratio,
                        seed):

    rng = np.random.default_rng(seed=seed)

    imgs = rng.binomial(1, pts_ratio, size=(num_imgs, length, length, 1)).astype('float32')

    imgs[:, 0, 0, 0] = 1.

    def get_sum_of_pts(images):
        return np.sum(np.sum(images, axis=1), axis=1)

    def calc_coordinates(images, axis):
        if axis == "x":
            return np.arange(length).reshape((1, 1, length, 1)) * images
        elif axis == "y":
            return np.arange(length).reshape((1, length, 1, 1)) * images

    def calc_mass_centre(images):

        num_of_pts = get_sum_of_pts(images)

        x_mean = get_sum_of_pts(calc_coordinates(images, 'x')) / num_of_pts
        y_mean = get_sum_of_pts(calc_coordinates(images, 'y')) / num_of_pts

        x_mean = x_mean.reshape(num_imgs, 1)
        y_mean = y_mean.reshape(num_imgs, 1)

        return np.append(x_mean, y_mean, axis=1)

    return {
        "imgs": imgs,
        "labels": calc_mass_centre(imgs),
    }
