from scipy.linalg import sqrtm
import numpy as np


def calculate_activation_statistics(images, model):
    activations = model.predict(images)
    mean = np.mean(activations, axis=0)
    cov = np.cov(activations, rowvar=False)
    return mean, cov


def calculate_frechet_distance(mu1, sigma1, mu2, sigma2):
    cov_mean, _ = sqrtm(np.dot(sigma1, sigma2), disp=False)
    if np.iscomplexobj(cov_mean):
        cov_mean = cov_mean.real
    fid = np.sum((mu1 - mu2)**2) + np.trace(sigma1 + sigma2 - 2 * cov_mean)
    return fid


def calculate_inception_score(images, model, num_splits=10):
    scores = []
    for i in range(num_splits):
        split_size = images.shape[0] // num_splits
        start, end = i * split_size, (i + 1) * split_size
        subset_images = images[start:end]
        activations = model.predict(subset_images)
        p_yx = np.mean(activations, axis=0)
        scores.append(np.sum(p_yx * np.log(p_yx / np.mean(p_yx))))
    return np.exp(np.mean(scores))

