# LinearizeLLM Context Experiment Setup

This context experiment setup allows you to test LinearizeLLM across three different information scenarios to understand the impact of parameter information on performance.

## 🎯 Experimental Scenarios

### 1. **No Context** (`no_context`)
- **Description**: Only the LaTeX optimization problem is provided
- **Information Available**: 
  - LaTeX model only
  - No parameter context
  - No concrete parameter values
- **Purpose**: Test baseline performance without any additional context

### 2. **Partial Information** (`partial_info`)
- **Description**: Parameter context is provided but no concrete values to detection/reformulation agents
- **Information Available**:
  - LaTeX model
  - Parameter context (which symbols are parameters vs decision variables)
  - Decision variable forms/types
  - **NO concrete parameter values** to detection and reformulation agents
- **Purpose**: Test impact of knowing variable types without concrete parameter values

### 3. **Full Information** (`full_info`)
- **Description**: Complete parameter and context information
- **Information Available**:
  - LaTeX model
  - Parameter context
  - Concrete parameter values (with instruction to ignore during detection)
  - Decision variable forms/types
- **Purpose**: Test performance with complete information (current baseline)

## 📁 Directory Structure

```
data/context_experiment_results/
├── context_experiment_summary.json  # Overall context experiment summary
├── no_context/                      # No context scenario results
│   ├── instance1/
│   │   ├── seed_1/
│   │   │   ├── context_experiment_results.json
│   │   │   ├── models/
│   │   │   ├── code/
│   │   │   └── steps/
│   │   ├── seed_2/
│   │   └── ...
│   └── ...
├── partial_info/                    # Partial information scenario results
│   └── ...
└── full_info/                       # Full information scenario results
    └── ...
```

## 🚀 Running Experiments

### Quick Start

1. **Test a single instance across all scenarios**:
   ```bash
   python run_experiments.py --mode test
   ```

2. **Run a single context experiment**:
   ```bash
   python run_experiments.py --mode single --instance media_selection_nonlinear_bincon --scenario no_context --seed 1
   ```

3. **Run the full context experiment suite** (315 experiments):
   ```bash
   python run_experiments.py --mode full
   ```

4. **Analyze results**:
   ```bash
   python run_experiments.py --mode analyze
   ```

### Direct Script Usage

You can also use the experimental setup script directly:

```bash
# Run full context experiment suite
python experimental_setup.py

# Run specific instances
python experimental_setup.py --instances media_selection_nonlinear_bincon netasgn_nonlinear_max

# Run specific scenarios
python experimental_setup.py --scenarios no_context partial_info

# Run specific seeds
python experimental_setup.py --seeds 1 2 3

# Run single context experiment
python experimental_setup.py --single-experiment --instance media_selection_nonlinear_bincon --scenario no_context --seed 1
```

## 📊 Analysis

### Automatic Analysis

After running context experiments, analyze the results:

```bash
python analyze_experimental_results.py
```

This will generate:
- `context_analysis_results/context_experiment_results.csv` - Raw data
- `context_analysis_results/context_scenario_analysis.json` - Scenario performance
- `context_analysis_results/context_instance_analysis.json` - Instance performance
- `context_analysis_results/plots/` - Performance visualizations
- `context_analysis_results/context_experiment_analysis_report.md` - Summary report

### Manual Analysis

You can also analyze specific aspects:

```bash
# Analyze with custom output directory
python analyze_experimental_results.py --output-dir my_context_analysis

# Analyze specific results directory
python analyze_experimental_results.py --results-dir custom_context_results_dir
```

## 📈 Expected Results

The context experiments will help answer:

1. **Detection Accuracy**: How does parameter information affect pattern detection?
2. **Reformulation Quality**: Does having parameter context improve reformulation?
3. **Optimization Success**: Does information level affect final optimization success?
4. **Performance Trade-offs**: What are the costs/benefits of different information levels?

## 🔧 Configuration

### Available Instances

The context experiment setup automatically discovers all available instances in `data/LinearizeLLM_data/instances_linearizellm/`:

- `aircraft_monotone_max`
- `blend_problem_abs`
- `blend_problem_frac`
- `diet_problem_min_abs`
- `diet_problem_monotone`
- `diet_problem_nonlinear_frac`
- `knapsack_problem_nonlinear_min_1`
- `knapsack_problem_nonlinear_min_2`
- `media_selection_nonlinear_binbin`
- `media_selection_nonlinear_bincon`
- `multi_nonlinear_abs`
- `netasgn_nonlinear_abs`
- `netasgn_nonlinear_max`
- `netmcol_nonlinear_bincon`
- `netmcol_nonlinear_frac`
- `nltrans_nonlinear_bincon`
- `nltrans_nonlinear_max`
- `prod_nonlinear_bincon`
- `prod_nonlinear_max`
- `revenue_maximization_nonlinear_bincon`

### LLM Models

Currently configured to use the "gemini_2_5_flash" model. You can modify this in the scripts or use command-line arguments.

## 📋 Experiment Workflow

Each context experiment follows this workflow:

1. **Load Problem**: Extract LaTeX model, parameters, and decisions
2. **Apply Scenario Filtering**: Filter information based on scenario
3. **Pattern Detection**: Detect nonlinear patterns with filtered information
4. **Reformulation**: Apply reformulations with filtered information
5. **Code Generation**: Generate Gurobi code (always with full information)
6. **Optimization**: Execute optimization and collect results
7. **Store Results**: Save all intermediate and final results

## 🔍 Understanding Results

### Success Metrics

- **Experiment Success**: Whether the entire pipeline completed
- **Pattern Detection Success**: Whether nonlinearities were correctly detected
- **Optimization Success**: Whether the generated code solved successfully
- **Solve Time**: Time taken for optimization (if successful)

### Key Files

- `context_experiment_results.json`: Complete context experiment results
- `context_experiment_error.json`: Error information if context experiment failed
- `extracted_patterns`: Raw pattern detection output
- `linearized_model.tex`: Reformulated LaTeX model
- `gurobi_code.py`: Generated Python code
- `optimization_results`: Final optimization results

## 🛠️ Troubleshooting

### Common Issues

1. **Missing Dependencies**: Ensure all LinearizeLLM dependencies are installed
2. **LLM API Issues**: Check your LLM model configuration
3. **File Permissions**: Ensure write permissions for results directories
4. **Memory Issues**: Large experiments may require significant memory

### Debugging

- Use `--quiet` flag to reduce verbose output
- Check individual experiment logs in the results directories
- Use single experiment mode to debug specific issues

## 📝 Customization

### Adding New Scenarios

To add new information scenarios:

1. Modify `ContextExperimentSetup.scenarios` in `experimental_setup.py`
2. Update `_apply_scenario_filtering()` method
3. Add scenario-specific logic for information filtering

### Modifying Analysis

To customize analysis:

1. Extend `ContextExperimentResultsAnalyzer` class
2. Add new analysis methods
3. Modify plotting functions for custom visualizations

## 🤝 Contributing

When adding new context experiments or analysis:

1. Follow the existing code structure
2. Add comprehensive documentation
3. Include error handling
4. Test with small experiments first
5. Update this README with new features 