#!/usr/bin/env python3
"""
Main entry point for the LinearizeLLM framework.
"""

import sys
import os
from pathlib import Path

# Add the src directory to the Python path
sys.path.insert(0, str(Path(__file__).parent / "src"))

# Check dependencies before importing any other modules
from utils.dependency_checker import check_dependencies

if not check_dependencies():
    print("\n❌ LinearizeLLM cannot start due to missing dependencies.")
    print("Please install all required packages and try again.")
    sys.exit(1)

from scripts.run_linearizellm_data import main

if __name__ == "__main__":
    main() 