import os
import sys
from pathlib import Path

def find_python_site_packages():
    # Suche nach dem site-packages Verzeichnis für Python 3.12
    python_path = sys.executable
    python_dir = Path(python_path).parent
    possible_site_packages = [
        python_dir / "Lib" / "site-packages",
        python_dir / "lib" / "python3.12" / "site-packages",  # Angepasst für Python 3.12
        python_dir.parent / "Lib" / "site-packages",
        Path(os.path.expanduser("~")) / "AppData" / "Local" / "Programs" / "Python" / "Python312" / "Lib" / "site-packages",  # Typischer Windows-Pfad für Python 3.12
        Path(os.path.expanduser("~")) / "AppData" / "Roaming" / "Python" / "Python312" / "site-packages"  # Alternative Location
    ]
    
    for path in possible_site_packages:
        if path.exists():
            return str(path)
    return None

def setup_gurobi():
    # Prüfe Python-Version
    if not sys.version.startswith("3.12"):
        print(f"Warnung: Dieses Skript ist für Python 3.12 optimiert. Aktuelle Version: {sys.version}")
        user_input = input("Möchten Sie trotzdem fortfahren? (j/n): ")
        if user_input.lower() != 'j':
            return False
    
    # Finde Python site-packages
    site_packages = find_python_site_packages()
    if site_packages:
        print(f"Python site-packages gefunden: {site_packages}")
        if site_packages not in sys.path:
            sys.path.append(site_packages)
    else:
        print("Python site-packages nicht gefunden!")
        print("Bitte stellen Sie sicher, dass Python 3.12.1 korrekt installiert ist.")
        return False
    
    # Typische Gurobi-Installationspfade
    possible_paths = [
        r"C:\gurobi1202\win64",   # Standardpfad für Gurobi 12.0.2
        r"C:\Program Files\Gurobi",
        r"C:\gurobi1000\win64",   
        r"C:\gurobi950\win64",    
        r"C:\gurobi902\win64",    
    ]
    
    # Suche nach dem Gurobi-Installationsverzeichnis
    gurobi_home = None
    for path in possible_paths:
        if Path(path).exists():
            gurobi_home = path
            break
    
    if gurobi_home is None:
        print("Gurobi-Installation konnte nicht gefunden werden.")
        print("Bitte geben Sie den Pfad zur Gurobi-Installation manuell ein:")
        gurobi_home = input().strip()
        if not Path(gurobi_home).exists():
            print("Ungültiger Pfad!")
            return False
    
    print(f"Gurobi-Installation gefunden: {gurobi_home}")
    
    # Setze Umgebungsvariablen
    os.environ["GUROBI_HOME"] = gurobi_home
    
    # Füge Gurobi zum Python-Pfad hinzu
    if gurobi_home not in sys.path:
        sys.path.append(gurobi_home)
    
    # Suche nach gurobipy in site-packages
    if site_packages:
        gurobi_paths = list(Path(site_packages).glob("*gurobi*"))
        if gurobi_paths:
            print("Gefundene Gurobi-Pakete:")
            for path in gurobi_paths:
                print(f"- {path}")
        else:
            print("\nKeine Gurobi-Pakete in site-packages gefunden.")
            print("Bitte führen Sie folgendes aus:")
            print(f"pip install gurobipy --target=\"{site_packages}\"")
    
    # Teste die Installation
    try:
        import gurobipy
        print("Gurobi wurde erfolgreich eingerichtet!")
        print(f"Gurobi Version: {gurobipy.gurobi.version()}")
        return True
    except ImportError as e:
        print(f"Fehler beim Import von gurobipy: {e}")
        print("\nBitte führen Sie folgende Schritte aus:")
        print("1. Überprüfen Sie, ob Gurobi korrekt installiert ist")
        print(f"2. Führen Sie 'pip install gurobipy --target=\"{site_packages}\"' aus")
        print("3. Stellen Sie sicher, dass die Umgebungsvariablen korrekt gesetzt sind")
        print("4. Wenn Sie eine akademische Lizenz haben, aktivieren Sie diese mit 'grbgetkey'")
        return False

if __name__ == "__main__":
    print(f"Python Version: {sys.version}")
    print(f"Python Executable: {sys.executable}")
    print(f"Python Path: {sys.path}")
    setup_gurobi() 