(* ::Package:: *)

getWorkingDirectory[] := Module[{},
  If[StringLength[$InputFileName] > 0, 
    (* Command-line execution: Use $InputFileName *)
    DirectoryName[$InputFileName], 
    If[$Notebooks, 
      (* GUI notebook execution: Use NotebookDirectory[] *)
      NotebookDirectory[], 
      (* Fallback: Default to current working directory *)
      Directory[]
    ]
  ]
]
SetDirectory[getWorkingDirectory[]]


MSEDir = FileNameJoin[{getWorkingDirectory[], "data"}];
MSEMC = Get[FileNameJoin[{MSEDir,  "data_MSE_MC.wl"}]]; (*load MSE for MC*)


(* ::Subsection:: *)
(*Plot MSE of Monte-Carlo under the best parameter and the parameter in the paper*)


exprMC1 = Simplify[MSEMC /. {a->-8, \[Sigma]->1, B->16384, \[Gamma]->9/10}];


NMinimize[{exprMC1, h>0 && h > T/16384 && T > 2 h}, {h, T}, WorkingPrecision->200] (*optimize over h and T*)


exprMC1 = Simplify[MSEMC /. {a->-8, \[Sigma]->1, B->16384, \[Gamma]->9/10, T->52}]; (*best T*)


exprMC2 = Simplify[MSEMC /. {a->-8, \[Sigma]->1, B->16384, \[Gamma]->9/10, T->8}]; (*TD setting in the paper*)


(* ::Text:: *)
(*Get the data for the plot in Fig. 6:*)


hList = 2^Range[-11,1];
resultsMCBest = Table[N[exprMC1 /. {h->hVal}, 5], {hVal, hList}]
resultsMCOur = Table[N[exprMC2 /. {h->hVal}, 5], {hVal, hList}]
