(* ::Package:: *)

(* ::Title:: *)
(*Mean-path semi-gradient TD(0), t=1*)


(* ::Input::Initialization:: *)
(*E[x^2 t]*)
Ex2[t_,a_,o_]:=o^2 / (2 a) (E^(2 a t) - 1);
(*E[x^2 s x^2 t]*)
Exs2xt2[s_,t_,a_,o_]:=o^4 / (4 a^2) (E^(2 a  s) - 1) E^(2 a t) (E^(-2 a s) - E^(-2 a t) + 3 (1 - E^(-2 a s)));
(*E[x^4 t]*)
Ex4[t_,a_, o_]:=3o^4/(4 a^2)(E^(2a t)-1)^2;
(*E[x^6 t]*)
Ex6[t_,a_, o_]:=15o^6/(8 a^3)(-3E^(4a t)+3E^(2a t)-1+E^(6a t));
(*E[x^8 t]*)
Ex8[t_,a_, o_]:=105 o^8 / (16 a ^4) (1-E^(2 a t))^4;
(*E[x^4 s x^2 t]*)
Exs4xt2[s_,t_,a_, o_]:=3o^6  E^(2 a t)/(8 a^3) (5(E^(4a s)-3E^(2 a s)- E^(-2 a s) + 3) + (1-E^(2 a s))^2 (E^(-2 a s)- E^(-2 a t)));
(*E[y^2 t]*)
Ey2[t_,a_]:=1/(2a)(1-E^(-2a t));
(*E[y^4 t]*)
Ey4[t_,a_]:=3/(4a^2)(1-E^(-2a t))^2;
(*E[y^6 t]*)
Ey6[t_,a_]:=15/(8a^3)(-3E^(-2a t)+3E^(-4a t)-E^(-6 a t)+1);
(*E[y^8 t]*)
Ey8[t_,a_]:=105 / (16 a ^4) (1-E^(-2 a t))^4;
(*E[y^2 s y^2 t]*)
Eys2yt2[s_,t_,a_]:= 1/(4a^2)(1-E^(-2 a s))((E^(-2 a s)-E^(-2 a t))+3(1-E^(-2 a s)));
(*E[y s y^3 t]*)
Eysyt3[s_,t_,a_]:= 3/(4a^2)(1-E^(-2 a s))(1-E^(-2 a t));
(*E[y^3 s y t]*)
Eys3yt[s_,t_,a_]:= Ey4[s,a];
(*E[y^2 (s,t)]*)
Eyst2[s_,t_,a_]:= 1/(2a)(E^(-2 a s)-E^(-2 a t));
(*E[y^4 (s,t)]*)
Eyst4[s_,t_,a_]:= Ey4[t,a] +  Ey4[s,a]+6Eys2yt2[s,t,a]-4(Eys3yt[s,t,a]+Eysyt3[s,t,a]);
(*E[y^6 (s,t)]*)
Eyst6[s_,t_,a_]:= 15/(8a^3)(E^(-6a s)- E^(-6a t)- 3 E^(-4a s) E^(-2a t) + 3 E^(-2a s) E^(-4a t));
(*E[x^2 s x^4 t]*)
Exs2xt4[s_, t_,a_,o_]:=o^6E^(2a s+4a t)(Ey6[s,a]+Ey2[s,a]Eyst4[s,t,a]+6Ey4[s,a]Eyst2[s,t,a]);
(*E[x^4 s x^4 t]*)
Exs4xt4[s_,t_,a_,o_]:= o^8 E^(4a s + 4a t) (Ey8[s,a]+ Ey4[s,a]Eyst4[s,t,a]+6Ey6[s,a]Eyst2[s,t,a]);
(*E[x^6 s x^2 t]*)
Exs6xt2[s_,t_,a_,o_]:=o^8E^(6 a s + 2 a t)(Ey8[s,a]+Eyst2[s,t,a] Ey6[s,a]);
(*E[\[Phi] s^2 \[Phi] t^2]*)
Eps2pt2[s_,t_,a_,o_,g_]:=Exs4xt4[s,t,a,o]+o^8/Log[g]^4-2o^2/Log[g](Exs2xt4[s,t,a,o]+Exs4xt2[s,t,a,o])+4o^4/Log[g]^2Exs2xt2[s,t,a,o]+o^4/Log[g]^2(Ex4[s,a,o]+Ex4[t,a,o])-2o^6/Log[g]^3(Ex2[s,a,o]+Ex2[t,a,o]);
(*E[\[Phi] t^4]*)
Ept4[t_,a_,o_,g_]:=Ex8[t,a,o]+o^8/Log[g]^4-4 o^6/Log[g]^3 Ex2[t,a,o]+6 o^4 /Log[g]^2 Ex4[t,a,o]-4o^2/(Log[g])Ex6[t,a,o];
(*E[\[Phi] s^3 \[Phi] t]*)
Eps3pt[s_,t_,a_,o_,g_]:=Exs6xt2[s,t,a,o]+o^8/Log[g]^4-o^6/Log[g]^3(Ex2[t,a,o]+3Ex2[s,a,o])+3o^4/Log[g]^2(Ex4[s,a,o]+Exs2xt2[s,t,a,o])-o^2/Log[g](Ex6[s,a,o]+3Exs4xt2[s,t,a,o]);
(*E[\[Phi] (t1) \[Phi] (t 2) \[Phi] (t 3) \[Phi] (t 4)],t 1<t 2<t 3<t 4
Expand in terms of y,y(t1,t2)...
Divide the time indices into non-overlapping intervals,such that we can omit the terms where individual variables are raised to odd powers as they are independent from other intervals and their expectation evaluate to 0*)
Ept1pt2pt3pt4[t1_,t2_,t3_,t4_,a_,o_,g_]:= Module[
{c,expr,filteredExpr, yt1,yt12,yt23,yt34},
c=1/Log[g];
expr = Expand[o^8( E^(2a t1)yt1^2-c)( E^(2a t2)(yt1+yt12)^2-c)( E^(2a t3)(yt1+yt12+yt23)^2-c)( E^(2a t4)(yt1+yt12+yt23+yt34)^2-c)];
filteredExpr=Total[Select[List@@expr,AllTrue[{yt1,yt12,yt23,yt34},Function[var,With[{exps=Exponent[#,var,"List"]},AllTrue[exps,EvenQ]]]]&]];
filteredExpr = filteredExpr /. yt1^n_:>Symbol["Ey"<>ToString[n]][t1,a];
filteredExpr = filteredExpr /. yt12^n_:>Symbol["Eyst"<>ToString[n]][t1,t2,a];
filteredExpr = filteredExpr /. yt23^n_:>Symbol["Eyst"<>ToString[n]][t2,t3,a];
filteredExpr = filteredExpr /. yt34^n_:>Symbol["Eyst"<>ToString[n]][t3,t4,a];
filteredExpr
];
(*E[\[Phi] (t1) \[Phi] (t 2) \[Phi] (t 3)^2], t1<t2<t3*)
Ept1pt2pt32[t1_,t2_,t3_,a_,o_,g_]:= Module[
{c,expr,filteredExpr, yt1,yt12,yt23},
c=1/Log[g];
expr = Expand[o^8( E^(2a t1)yt1^2-c)( E^(2a t2)(yt1+yt12)^2-c)( E^(2a t3)(yt1+yt12+yt23)^2-c)^2];
filteredExpr=Total[Select[List@@expr,AllTrue[{yt1,yt12,yt23},Function[var,With[{exps=Exponent[#,var,"List"]},AllTrue[exps,EvenQ]]]]&]];
filteredExpr = filteredExpr /. yt1^n_:>Symbol["Ey"<>ToString[n]][t1,a];
filteredExpr = filteredExpr /. yt12^n_:>Symbol["Eyst"<>ToString[n]][t1,t2,a];
filteredExpr = filteredExpr /. yt23^n_:>Symbol["Eyst"<>ToString[n]][t2,t3,a];
filteredExpr
];
(*E[\[Phi] (t 1)^2 \[Phi] (t 2) \[Phi] (t 3)],t 1<t 2<t 3*)
Ept12pt2pt3[t1_,t2_,t3_,a_,o_,g_]:= Module[
{c,expr,filteredExpr, yt1,yt12,yt23},
c=1/Log[g];
expr = Expand[o^8( E^(2a t1)yt1^2-c)^2( E^(2a t2)(yt1+yt12)^2-c)( E^(2a t3)(yt1+yt12+yt23)^2-c)];
filteredExpr=Total[Select[List@@expr,AllTrue[{yt1,yt12,yt23},Function[var,With[{exps=Exponent[#,var,"List"]},AllTrue[exps,EvenQ]]]]&]];
filteredExpr = filteredExpr /. yt1^n_:>Symbol["Ey"<>ToString[n]][t1,a];
filteredExpr = filteredExpr /. yt12^n_:>Symbol["Eyst"<>ToString[n]][t1,t2,a];
filteredExpr = filteredExpr /. yt23^n_:>Symbol["Eyst"<>ToString[n]][t2,t3,a];
filteredExpr
];
(*E[\[Phi] (s)^2 \[Phi] (t) r (s)],s<t*)
Eps2ptrs[s_,t_,a_,o_,g_,h_]:=Module[
{c,expr},
c=o^2/Log[g];
expr=- h (Exs6xt2[s,t,a,o]-c Ex6[s,a,o]+c^2 Exs2xt2[s,t,a,o] -c^3Ex2[s,a,o]-2c Exs4xt2[s,t,a,o]+2c^2Ex4[s,a,o]);
expr
];
(*E[\[Phi] (s)^3 r(s)]*)
Eps3rs[s_,a_,o_,g_,h_]:=-h(Ex8[s,a,o]-o^6/Log[g]^3Ex2[s,a,o]-3Ex6[s,a,o]o^2/Log[g]+3Ex4[s,a,o]o^4/Log[g]^2);
(*E[\[Phi](t1) \[Phi] (t2) \[Phi] (t3) r(t1)]*)
Ept1pt2pt3rt1[t1_,t2_,t3_,a_,o_,g_,h_]:=Module[
{c,expr,filteredExpr, yt1,yt12,yt23},
c=1/Log[g];
expr = Expand[-h o^8E^(2a t1)yt1^2(E^(2 a t1)yt1^2-c)( E^(2a t2)(yt1+yt12)^2-c)( E^(2a t3)(yt1+yt12+yt23)^2-c)];
filteredExpr=Total[Select[List@@expr,AllTrue[{yt1,yt12,yt23},Function[var,With[{exps=Exponent[#,var,"List"]},AllTrue[exps,EvenQ]]]]&]];
filteredExpr = filteredExpr /. yt1^n_:>Symbol["Ey"<>ToString[n]][t1,a];
filteredExpr = filteredExpr /. yt12^n_:>Symbol["Eyst"<>ToString[n]][t1,t2,a];
filteredExpr = filteredExpr /. yt23^n_:>Symbol["Eyst"<>ToString[n]][t2,t3,a];
filteredExpr
];
(*E[\[Phi] (t1) \[Phi] (t 2) \[Phi] (t3) r (t3)]*)
Ept1pt2pt3rt3[t1_,t2_,t3_,a_,o_,g_,h_]:=Module[
{c,expr,filteredExpr, yt1,yt12,yt23},
c=1/Log[g];
expr = Expand[-h o^8(E^(2 a t1)yt1^2-c)( E^(2a t2)(yt1+yt12)^2-c)( E^(2a t3)(yt1+yt12+yt23)^2-c)E^(2a t3)(yt1+yt12+yt23)^2];
filteredExpr=Total[Select[List@@expr,AllTrue[{yt1,yt12,yt23},Function[var,With[{exps=Exponent[#,var,"List"]},AllTrue[exps,EvenQ]]]]&]];
filteredExpr = filteredExpr /. yt1^n_:>Symbol["Ey"<>ToString[n]][t1,a];
filteredExpr = filteredExpr /. yt12^n_:>Symbol["Eyst"<>ToString[n]][t1,t2,a];
filteredExpr = filteredExpr /. yt23^n_:>Symbol["Eyst"<>ToString[n]][t2,t3,a];
filteredExpr
];
(*E[\[Phi] s \[Phi] t^2 r s]*)
Epspt2rs[s_,t_,a_,o_,g_,h_]:=Module[
{c,expr},
c=o^2/Log[g];
expr=-h (Exs4xt4[s,t,a,o]-c Exs2xt4[s,t,a,o]+c^2 Ex4[s,a,o] -c^3Ex2[s,a,o]-2c Exs4xt2[s,t,a,o]+2c^2Exs2xt2[s,t,a,o]);
expr
];
(*E[\[Phi]^2 s \[Phi] t r t]*)
Eps2ptrt[s_,t_,a_,o_,g_,h_]:=Module[
{c,expr},
c=o^2/Log[g];
expr=-h (Exs4xt4[s,t,a,o]-c Exs4xt2[s,t,a,o]+c^2 Ex4[t,a,o] -c^3Ex2[t,a,o]-2c Exs2xt4[s,t,a,o]+2c^2Exs2xt2[s,t,a,o]);
expr
];
(*E[\[Phi] t r t]*)
Eptrt[t_,a_,o_,g_,h_]:=-h(Ex4[t,a,o]-o^2/Log[g]Ex2[t,a,o]);
(*E[\[Gamma]^h \[Phi] s \[Phi] t-\[Phi] s^2]*)
EpsptMinusps2[s_,t_,a_,o_,g_,h_]:=g^h Exs2xt2[s,t,a,o]+o^4/Log[g]^2(g^h-1)-Ex4[s,a,o]+o^2/Log[g]((2-g^h)Ex2[s,a,o]-g^h Ex2[t,a,o]);
(*Infinite horizon cost V*)
V[a_,o_,g_]:=Integrate[-g^t Ex2[t,a,o],{t,0,Infinity},Assumptions->{a<0,0<g<1}];


(* ::Input::Initialization:: *)
(*Expectation of Gradient of Theta (EGT):E[g(\[Theta])]=EGT1+EGT2*)
EGT1[h_,N_,a_,o_,g_]:=Evaluate[Simplify[-h o^4/(2 a (N-1))
( (3/(2a)+1/Log[g])(N-1)
-(3/a+1/Log[g])(1-E^(2a (N -1)h))/(1-E^(2 a h))+ 3/(2a)(1-E^(4 a (N-1) h))/(1-E^(4 a h))),{ a <0, h > 0, N>0,o>0, 0 < g<1}]];
EGT2[h_,N_,a_,o_,g_,th_]:=Evaluate[Simplify[th/(N-1) Sum[EpsptMinusps2[k h, k h+h,a,o,g,h],{k,0,N-2}]]];
EGT[h_,N_,a_,o_,g_,th_]:=Evaluate[Simplify[EGT1[h,N,a,o,g]+EGT2[h,N,a,o,g,th]]];
(*Expectation of Gradient of Theta Square:E[g(\[Theta])^2]=TERM4+TERM5+TERM6*)
TERM4[h_,B_,N_,a_,o_,g_]:= Evaluate[Simplify[h^2 N/((N -1)^2B)( Sum[Ex8[k h, a, o]+o^4/Log[g]^2 Ex4[k h,a,o]-2o^2/Log[g]Ex6[k h, a,o],{k,0,N-2}]+2Sum[Exs4xt4[k h,l h, a, o]+o^4/Log[g]^2Exs2xt2[k h,l h,a,o]-o^2/Log[g]Exs4xt2[k h,l h,a,o]-o^2/Log[g]Exs2xt4[k h,l h,a,o],{k,0,N-3},{l,k+1,N-2}]+(B/N-1)o^8/(4a^2)(9/(4a^2)Sum[(E^(2a h k)-1)^2,{k,0,N-2}]^2+ 1/Log[g]^2Sum[(E^(2a h k)-1),{k,0,N-2}]^2-3/(a Log[g])Sum[(E^(2a h k)-1)^2,{k,0,N-2}]Sum[(E^(2a h k)-1),{k,0,N-2}] ))]];
TERM7a[h_,B_,N_,a_,o_,g_]:= Evaluate[Simplify[B/N Sum[ g^(2h)Eps2pt2[k h, k h+h,a,o,g]+Ept4[k h, a, o, g]-2g^ h Eps3pt[k h, k h+h,a,o,g],{k,0,N-2}]]];
TERM7b[h_,B_,N_,a_,o_,g_]:=Evaluate[Simplify[2B/N Sum[g^(2h)Ept1pt2pt3pt4[k h, k h+h,l h,l h+h,a,o,g]+Eps2pt2[k h, l h, a, o,g]-g^h Ept1pt2pt32[k h, k h+h,l h,a,o,g]-g^h Ept12pt2pt3[k h, l h, l h+h,a,o,g], {k,0,N-3},{l,k+1,N-2}]]];
TERM8[h_,B_,N_,a_,o_,g_]:=Evaluate[Simplify[B/N(B/N-1)(Sum[EpsptMinusps2[k h,k h+h,a,o,g,h],{k,0,N-2}])^2]];
TERM5[h_,B_,N_,a_,o_,g_,th_]:=Evaluate[Simplify[th^2N^2/(B^2 (N-1)^2)(TERM7a[h,B,N,a,o,g]+TERM7b[h,B,N,a,o,g]+TERM8[h,B,N,a,o,g])]];
(*TERM9 has the sum broken down in 3 cases:k=l,k<l and k>l*)
TERM9[h_,B_,N_,a_,o_,g_]:=
B/N Sum[g^h Eps2ptrs[k h,k h+h,a,o,g,h]-Eps3rs[k h, a, o, g,h],{k,0,N-2}]+
B/N Sum[g^h Ept1pt2pt3rt1[k h, l h, l h+h, a, o, g,h]- Epspt2rs[k h, l h, a, o, g,h],{k,0,N-3},{l,k+1,N-2}]+
B/N Sum[g^h Ept1pt2pt3rt3[l h, l h+h, k h, a, o, g,h]- Eps2ptrt[l h, k h, a, o, g,h],{k,1,N-2},{l,0,k-1}];
TERM10[h_,B_,N_,a_,o_,g_]:=B/N(B/N-1) Sum[Eptrt[k h,a,o,g,h],{k,0,N-2}]Sum[ EpsptMinusps2[k h, k h+h, a, o, g,h],{k,0,N-2}];
TERM6[h_,B_,N_,a_,o_,g_,th_]:=Evaluate[Simplify[2th N^2/(B^2(N-1)^2)(TERM9[h,B,N,a,o,g]+TERM10[h,B,N,a,o,g])]];


(* ::Input::Initialization:: *)
(*E[\[Theta]]*)
ET[h_,N_,a_,o_,g_,th_,alpha_]:=th+alpha EGT[h,N,a,o,g,th];
Print["ET: ",ET[h,N,a,o,g,\[Theta],\[Alpha]]]; 
Print["Leafcount of ET:",LeafCount[ET[h,N,a,o,g,\[Theta],\[Alpha]]]];
(*E[g(\[Theta])^2]*)
(*EGTsq[h_,B_,N_,a_,o_,g_,th_]:=Evaluate[Simplify[TERM4[h,B,N,a,o,g] + TERM5[h,B,N,a,o,g,th]+TERM6[h,B,N,a,o,g,th]]]*)
EGTsq[h_,B_,N_,a_,o_,g_,th_]:=Evaluate[Simplify[TERM4[h,B,N,a,o,g]+TERM5[h,B,N,a,o,g,th]+TERM6[h,B,N,a,o,g,th],Assumptions->{o>0,B>=N>0,h>0,a<0,0<g<1}]];
(*E[\[Theta]^2]*)
ETsq[h_,B_,N_,a_,o_,g_,th_,alpha_]:=Evaluate[Simplify[th^2+2th alpha EGT[h,N,a,o,g,th]+alpha^2 EGTsq[h,B,N,a,o,g,th],Assumptions->{o>0,B>=N>0,h>0,a<0,0<g<1}]];
Print["Leafcount of ETsq with assumptions: ",LeafCount[ETsq[h,B,N,a,o,g,\[Theta],\[Alpha]]]];
Print["Variables of ETsq with assumptions: ",Variables[ETsq[h,B,N,a,o,g,\[Theta],\[Alpha]]]];


MSE[h_,B_,T_,a_,o_,g_,th_,alpha_]:= Evaluate[Simplify[o^4/Log[g]^2(ETsq[h,B,T/h,a,o,g,th,alpha]-2/(Log[g]+2a)ET[h,T/h,a,o,g,th,alpha]+1/(Log[g]+2a)^2),Assumptions->{o>0,B>=N>0,h>0,a<0,0<g<1}]];
Print["LeafCount of MSE: ", LeafCount[MSE[h,B,T,a,\[Sigma],\[Gamma],\[Theta],\[Alpha]]];
Print["Variables of MSE: ", Variables[MSE[h,B,T,a,\[Sigma],\[Gamma],\[Theta],\[Alpha]]]];
