(* ::Package:: *)

(* ::Title:: *)
(*t-step MSE*)


(* ::Input::Initialization:: *)
C0[\[Sigma]_,\[Gamma]_, a_, \[Theta]_]:=\[Sigma]^4/(Log[\[Gamma]]^2)(\[Theta]-1/(Log[\[Gamma]]+2a))^2
C0[\[Sigma],\[Gamma],a,\[Theta]]


C11[\[Sigma]_,\[Gamma]_,a_,T_]:= -\[Sigma]^4/(16 a^3 T Log[\[Gamma]]) (4a - 4a E^(2 a T)+ 8a^2 T + 3Log[\[Gamma]](3-4E^(2a T)+E^(4 a T)+ 4 a T))
C11[\[Sigma],\[Gamma],a,T]


C12[\[Sigma]_,\[Gamma]_,a_,T_]:=-\[Sigma]^4 ((1-E^(2 a T)- a T+3 a T E^(2 a T)) / (4 a^2 T^2 Log[\[Gamma]])
			+ 3(3- 4 E^(2 a T) + E^(4 a T) - 2 a T + 12 a T E^(2 a T)- 6 a T E^(4 a T))/ (16 a^3 T^2)
)
C12[\[Sigma],\[Gamma],a,T]


C21[\[Sigma]_,\[Gamma]_,a_,T_]:=-(2 a + Log[\[Gamma]])C11[\[Sigma],\[Gamma],a,T]
C321[\[Sigma]_,\[Gamma]_,a_,T_]:=C11[\[Sigma],\[Gamma],a,T]^2
C421[\[Sigma]_,\[Gamma]_,a_,T_]:=(2 a + Log[\[Gamma]])^2 C11[\[Sigma],\[Gamma],a,T]^2
C521[\[Sigma]_,\[Gamma]_,a_,T_]:=-(2 a +Log[\[Gamma]]) C11[\[Sigma],\[Gamma],a,T]^2


C21[\[Sigma],\[Gamma],a,T]


C31[\[Sigma]_,\[Gamma]_,a_,T_]:=\[Sigma]^8 ((5-E^(4a T)+4 a T- 4E^(2 a T)+ 8 a T E^(2a T))/ (8a^4 T(Log[\[Gamma]]^2))
				+ 3 (11+E^(6a T)+8 a T - 9E^(2a T)+20a T E^(a T)- 3E^(4 a T)-4 a T E^(4 a T)) / (8a^5 T Log[\[Gamma]])
				+ (61 + 29 E^(6a T)-3E^(8a T)+42a T-18E^(4a T)-90a T E^(4a T)-69 E^(2 a T)+108a T E^(2a T))/ (8a^6 T))


C31[\[Sigma],\[Gamma],a,T]


C1[\[Sigma]_,\[Gamma]_, a_, \[Theta]_,t_, \[Alpha]_, B_, T_]:= t \[Alpha] \[Sigma]^4 /(Log[\[Gamma]])^2 (\[Theta]-1/(Log[\[Gamma]]+2a))^2 (-2(2a+Log[\[Gamma]]) C11[\[Sigma],\[Gamma], a, T]
     + \[Alpha] (2t-1)(Log[\[Gamma]]+2a)^2 C31[\[Sigma],\[Gamma], a, T] / B)


C1[\[Sigma],\[Gamma],a,\[Theta],t,\[Alpha],B,T]


C23[\[Sigma]_,\[Gamma]_, a_,T_]:=3\[Sigma]^4/(32a^3 T) (2a+Log[\[Gamma]])^2 (3-4E^(2 a T)+E^(4 a T)+ 4 a T)


C320[\[Sigma]_,\[Gamma]_, a_,B_, T_]:= \[Sigma]^8(
(4E^(2 a T)(1 - 2 a T + 3 a^2 T^2)+E^(4 a T) (-1 + 3 a T)- a T -5)/(4 a^4 T^2 Log[\[Gamma]]^2)
+3 (E^(6 a T) (-2 + 9 a T)+ 2 E^(4 a T) (3 - 8 a T - 12 a^2 T^2))/(8 a^5 T^2 Log[\[Gamma]])
+ 3(E^(2 a T) (18 -37 a T + 60 a^2 T^2) - 4a T - 22)/(8 a^5 T^2 Log[\[Gamma]])
+ (6 E^(8 a T)(1 - 6 a T)+ 29 E^(6 a T)(-2+9 a T)+ 9 E^(4 a T)(4 - 7 a T- 60 a^2 T^2))/(8 a^6 T^2)
+ (3 E^(2 a T) (46 - 87 a T + 108 a^2 T^2 )- 21 a T - 122)/(8 a^6 T^2))


C320[\[Sigma],\[Gamma],a,B,T]


C2[\[Sigma]_,\[Gamma]_, a_, \[Theta]_,t_, \[Alpha]_, B_, T_]:= t \[Alpha] \[Sigma]^4 /(Log[\[Gamma]])^2 (\[Theta]-1/(Log[\[Gamma]]+2a))^2 (2C23[\[Sigma],\[Gamma],a,T] - 2(2a+Log[\[Gamma]])C12[\[Sigma],\[Gamma],a,T]
					+ (C11[\[Sigma],\[Gamma],a,T]^2 - C320[\[Sigma],\[Gamma],a,B,T]/B)(2a+Log[\[Gamma]])^2(t \[Alpha]+(t-1)\[Alpha]))


C2[\[Sigma],\[Gamma], a, \[Theta],t, \[Alpha], B, T]


MSE[h_,\[Sigma]_,\[Gamma]_,a_,\[Theta]_,t_,\[Alpha]_,B_,T_]:= C0[\[Sigma],\[Gamma],a,\[Theta]]+ C1[\[Sigma],\[Gamma],a,\[Theta],t,\[Alpha],B,T] h + C2[\[Sigma],\[Gamma], a, \[Theta],t, \[Alpha], B, T] h^2


simpleMSE = Simplify[MSE[h,\[Sigma],\[Gamma],a,\[Theta],t,\[Alpha],B,T]];


Print["Approximate MSE for t-step: \n", simpleMSE];


(* ::Subsection:: *)
(*Set t=1, compare with exact MSE for one-step update*)


getWorkingDirectory[] := Module[{},
  If[StringLength[$InputFileName] > 0, 
    (* Command-line execution: Use $InputFileName *)
    DirectoryName[$InputFileName], 
    If[$Notebooks, 
      (* GUI notebook execution: Use NotebookDirectory[] *)
      NotebookDirectory[], 
      (* Fallback: Default to current working directory *)
      Directory[]
    ]
  ]
]
SetDirectory[getWorkingDirectory[];
MSEDir = FileNameJoin[{getWorkingDirectory[], "data"}]
MSEOneStep = Get[FileNameJoin[{MSEDir, "data_MSE_OneStepTD.wl"}]];


plotOneStep = Plot[
  MSEOneStep /. {\[Sigma]->1,\[Gamma]->99/100,a->-1,\[Theta]->-1,\[Alpha]->1,B->10^5,T->20},
  {h, 1/10000, 1/30},
  PlotRange      -> All,
  AxesLabel      -> {"h", "MSE"},
  LabelStyle -> Directive[Black, 20],
  WorkingPrecision -> 200,
  PlotLabel      -> "MSE_1 vs h",
  PlotStyle -> Directive[Thick, Opacity[0.5, Orange]]
]


params = {\[Sigma]->1,\[Gamma]->99/100,a->-1,\[Theta]->-1,t->1,\[Alpha]->1,B->10^5,T->20};
plotMultiStep = Plot[
  simpleMSE /. params,
  {h, 1/10000, 1/30},
  PlotRange      -> All,
  AxesLabel      -> {"h", "MSE"},
  LabelStyle -> Directive[Black, 20],
  WorkingPrecision -> 200,
  PlotLabel      -> "MSE_t (t=1) vs h",
  PlotStyle -> Directive[Thick, Opacity[0.5, Blue]]
]


combinedPlot = Show[plotOneStep, plotMultiStep, 
	PlotLabel -> "MSE_1 vs MSE_t (t=1)", 
	AxesLabel -> {"h", "MSE"}, 
	PlotRange -> All,
	AxesOrigin -> {Automatic, Automatic},
    LabelStyle -> Directive[Black, 20],
    TicksStyle -> Directive[Black, 20]
    ]
