import numpy as np
import pickle


def load_npy(fname, verbose=True):
    """This function loads data from a npy named `fname`

    Returns:
        the loaded data
    """
    if verbose:
        print(f"loading {fname}")
    try:
        with open(fname, "rb") as f:
            return np.load(f)
    except FileNotFoundError:
        print(f"file {fname}, not found")
        assert False


def load_npz(fname, verbose=True):
    """This function loads data from a npz named `fname`

    Returns:
        the loaded data
    """
    if verbose:
        print(f"loading {fname}")
    try:
        with open(fname, "rb") as f:
            npzfile = np.load(f)
            data = {key: npzfile[key] for key in npzfile.files}
            return data
    except FileNotFoundError:
        print(f"file {fname}, not found")
        assert False


def load_pickle(fname, verbose=True):
    """This function loads data from a pickle file named `fname`

    Returns:
        the loaded data
    """
    if verbose:
        print(f"loading {fname}")
    try:
        with open(fname, "rb") as f:
            return pickle.load(f)
    except FileNotFoundError:
        print(f"file {fname}, not found")
        assert False
