#!/bin/bash

# List of values for the parameters
a_values=(-8.0)
theta0_values=(0)
T_values=(8)
gamma_values=(0.9)
B_values=(4096 65536)
alpha_values=(0.1 1.0 10.0)
nb_steps_values=(100)

# Calculate total number of combinations
total_combos=$(( ${#a_values[@]} * ${#theta0_values[@]} * ${#T_values[@]} * ${#gamma_values[@]} * ${#B_values[@]} * ${#alpha_values[@]} * ${#nb_steps_values[@]} ))
echo "Total combinations: $total_combos"

# Initialize progress counter
progress=0

# Loop through all combinations
for a in "${a_values[@]}"; do
  for theta0 in "${theta0_values[@]}"; do
    for T in "${T_values[@]}"; do
      for gamma in "${gamma_values[@]}"; do
        for B in "${B_values[@]}"; do
          for alpha in "${alpha_values[@]}"; do
            for nb_steps in "${nb_steps_values[@]}"; do
              # Increment progress
              progress=$((progress + 1))

              # Generate a unique log file name based on parameter values
              log_file="a_${a}_theta0_${theta0}_T_${T}_gamma_${gamma}_B_${B}_alpha_${alpha}_nbsteps_${nb_steps}.log"

              # Print progress
              echo "Progress: $progress / $total_combos"

              # Command to execute
              cmd="python -m TD.main --mode compute --a $a --B $B --T $T --lr_scheduler constant --alpha $alpha --nb_steps $nb_steps --theta0 $theta0 --gamma $gamma"

              # Log the command and its output to the unique log file
              echo "Executing: $cmd" | tee -a "$log_file"
              $cmd 2>&1 | tee -a "$log_file"
            done
          done
        done
      done
    done
  done
done

echo "All commands completed."