#!/bin/bash

output_dir="./data/output/neurips"
mkdir -p $output_dir

export GRB_LICENSE_FILE=../gurobi.lic

for i in 1 3 9
do
    echo "Running all four benchmarks with memval=$i!"
    (time python3 src/main.py --prism ../data/input/envs/prism/collision.prism --intervals src/models/aircraft/collision-rew.intervals --method 'scp' --spec 'R=? [ F "goal" ]' --type "rew" --threshold 0.1 --memval ${i} > ${output_dir}/collision-rew-memval-$i.txt; ) 2> ${output_dir}/collision-rew-memval-$i-time.txt
    (time python3 src/main.py --prism ../data/input/envs/prism/evade-large.prism --intervals intervals --method 'scp' --spec 'R=? [ F "goal" ]' --type "rew" --threshold 0.1 --memval ${i} > ${output_dir}/evade-large-memval-$i.txt; ) 2> ${output_dir}/evade-large-memval-$i-time.txt
    (time python3 src/main.py --prism ../data/input/envs/prism/intercept-large.prism --intervals intervals --method 'scp' --spec 'R=? [ F "goal" ]' --type "rew" --threshold 0.1 --memval ${i} > ${output_dir}/intercept-large-memval-$i.txt; ) 2> ${output_dir}/intercept-large-memval-$i-time.txt
    (time python3 src/main.py --prism ../data/input/envs/prism/avoid-large.prism --intervals intervals --method 'scp' --spec 'R=? [ F "goal" ]' --type "rew" --threshold 0.1 --memval ${i} > ${output_dir}/avoid-large-memval-$i.txt; ) 2> ${output_dir}/avoid-large-memval-$i-time.txt
done

echo "Done!"

