#!/bin/bash

output_dir="./files/scp/output/icml/small"
mkdir -p $output_dir

export GRB_LICENSE_FILE=../gurobi.lic

property="'Rmin=? [ F \"goal\" ]'"
defaults="--intervals intervals --method scp --spec ${property} --type rew --threshold 0.1"

echo ${defaults}

for i in 1 3 4 8
do
    echo "Running all four small benchmarks with memval=$i!"
    (time python3 src/main.py --prism ../data/input/envs/prism/evade.prism --intervals intervals --method 'scp' --spec 'R=? [ F "goal" ]' --type "rew" --threshold 0.1 --memval ${i} > ${output_dir}/evade-memval-$i.txt; ) 2> ${output_dir}/evade-memval-$i-time.txt
    (time python3 src/main.py --prism ../data/input/envs/prism/intercept.prism --intervals intervals --method 'scp' --spec 'R=? [ F "goal" ]' --type "rew" --threshold 0.1 --memval ${i} > ${output_dir}/intercept-memval-$i.txt; ) 2> ${output_dir}/intercept-memval-$i-time.txt
    (time python3 src/main.py --prism ../data/input/envs/prism/avoid.prism --intervals intervals --method 'scp' --spec 'R=? [ F "goal" ]' --type "rew" --threshold 0.1 --memval ${i} > ${output_dir}/avoid-memval-$i.txt; ) 2> ${output_dir}/avoid-memval-$i-time.txt
done

echo "Done!"

