__all__ = []

import logging

from fastbo.try_import import try_import_aws_message, try_import_backends_message

try:
    from fastbo.backend.local_backend import LocalBackend  # noqa: F401
    from fastbo.backend.python_backend.python_backend import (
        PythonBackend,
    )  # noqa: F401

    __all__ = ["LocalBackend", "PythonBackend"]
except ImportError:
    logging.info(try_import_backends_message())

try:
    from fastbo.backend.sagemaker_backend.sagemaker_backend import (  # noqa: F401
        SageMakerBackend,
    )

    __all__.append("SageMakerBackend")
except ImportError:
    logging.info(try_import_aws_message())
