from fastbo.tuner_callback import TunerCallback


class RemoveCheckpointsCallback(TunerCallback):
    """
    This implements early removal of checkpoints of paused trials. In order
    for this to work, the scheduler needs to implement
    :meth:`~syne_tune.optimizer.scheduler.TrialScheduler.trials_checkpoints_can_be_removed`.
    """

    def __init__(self):
        self._tuner = None

    def on_tuning_start(self, tuner):
        self._tuner = tuner

    def on_loop_end(self):
        for trial_id in self._tuner.scheduler.trials_checkpoints_can_be_removed():
            self._tuner.trial_backend.delete_checkpoint(trial_id)
