from typing import Dict, Any
import logging
from fastbo.optimizer.schedulers.fastbo import FastBOScheduler

logger = logging.getLogger(__name__)


def _assert_searcher_must_be(kwargs: Dict[str, Any], name: str):
    searcher = kwargs.get("searcher")
    assert searcher is None or searcher == name, f"Must have searcher='{name}'"


class FastBO(FastBOScheduler):
    """Gaussian process based Bayesian optimization, partial evaluation.

    :param config_space: Configuration space for evaluation function
    :param metric: Name of metric to optimize
    :param kwargs: Additional arguments to
        :class:`~syne_tune.optimizer.schedulers.FIFOScheduler`
    """

    def __init__(self, config_space: Dict[str, Any], metric: str, **kwargs):
        searcher_name = "fastbo"
        _assert_searcher_must_be(kwargs, searcher_name)
        super(FastBO, self).__init__(
            config_space=config_space,
            metric=metric,
            searcher=searcher_name,
            **kwargs,
        )