import logging

from fastbo.try_import import try_import_raytune_message
from fastbo.optimizer.schedulers.fifo import FIFOScheduler
from fastbo.optimizer.schedulers.fastbo.fastbo import FastBOScheduler
from fastbo.optimizer.schedulers.hyperband import HyperbandScheduler
from fastbo.optimizer.schedulers.median_stopping_rule import MedianStoppingRule
from fastbo.optimizer.schedulers.pbt import PopulationBasedTraining

__all__ = [
    "FIFOScheduler",
    "FastBO",
    "HyperbandScheduler",
    "MedianStoppingRule",
    "PopulationBasedTraining",
]

try:
    from fastbo.optimizer.schedulers.ray_scheduler import (  # noqa: F401
        RayTuneScheduler,
    )

    __all__.append("RayTuneScheduler")
except ImportError:
    logging.info(try_import_raytune_message())
