class FastBOManager:
    """
    Maintains two crucial points

    Mode "direct":
        Use the specified efficient point and saturation point for
        each configuration. In this case, `self.warmup_point` is set as
        the specified efficient point.
    Mode "indirect":
        Obtain efficient point and saturation point for each con-
        figuration by modeling its learning curve, and use them. In this
        case, `self.efficient_point` and `self.saturation_point`
        are no use.
    """

    def __init__(
            self,
            warmup_point: float,
            efficient_point: float,
            saturation_point: float,
    ):
        if warmup_point == 1.0:
            self.mode = "direct"
            self.warmup_point = efficient_point
            self.saturation_point = saturation_point
        else:
            self.mode = "indirect"
            self.warmup_point = warmup_point
