import logging

from fastbo.try_import import try_import_gpsearchers_message

from fastbo.optimizer.schedulers.searchers.searcher import (  # noqa: F401
    BaseSearcher,
    impute_points_to_evaluate,
)
from fastbo.optimizer.schedulers.searchers.searcher_base import (  # noqa: F401
    StochasticSearcher,
    StochasticAndFilterDuplicatesSearcher,
    extract_random_seed,
)
from fastbo.optimizer.schedulers.searchers.random_grid_searcher import (  # noqa: F401
    RandomSearcher,
    GridSearcher,
)
from fastbo.optimizer.schedulers.searchers.searcher_factory import (  # noqa: F401
    searcher_factory,
)

__all__ = [
    "BaseSearcher",
    "impute_points_to_evaluate",
    "StochasticSearcher",
    "StochasticAndFilterDuplicatesSearcher",
    "extract_random_seed",
    "RandomSearcher",
    "GridSearcher",
    "searcher_factory",
]

try:
    from fastbo.optimizer.schedulers.searchers.model_based_searcher import (  # noqa: F401
        ModelBasedSearcher,
    )
    from fastbo.optimizer.schedulers.searchers.gp_fifo_searcher import (  # noqa: F401
        GPFIFOSearcher,
    )
    from fastbo.optimizer.schedulers.searchers.gp_multifidelity_searcher import (  # noqa: F401
        GPMultiFidelitySearcher,
    )

    __all__.extend(
        [
            "ModelBasedSearcher",
            "GPFIFOSearcher",
            "GPMultiFidelitySearcher",
        ]
    )
except ImportError:
    logging.info(try_import_gpsearchers_message())
