from typing import Optional


def try_import_gpsearchers_message() -> str:
    return _try_import_message(
        "Gaussian process based searchers are not imported", tag="gpsearchers"
    )


def try_import_kde_message() -> str:
    return _try_import_message("KDE searchers are not imported", tag="kde")


def try_import_bore_message() -> str:
    return _try_import_message("BORE searchers are not imported", tag="bore")


def try_import_raytune_message() -> str:
    return _try_import_message(
        "Ray Tune schedulers and searchers are not imported", tag="raytune"
    )


def try_import_benchmarks_message() -> str:
    return _try_import_message(
        "Dependencies for benchmarks are not imported", tag="benchmarks"
    )


def try_import_aws_message() -> str:
    return _try_import_message("AWS dependencies are not imported", tag="aws")


def try_import_botorch_message() -> str:
    return _try_import_message("BoTorch dependencies are not imported", tag="botorch")


def try_import_blackbox_repository_message() -> str:
    return _try_import_message(
        "Dependencies of blackbox repository are not imported",
        tag="blackbox-repository",
    )


def try_import_yahpo_message() -> str:
    return _try_import_message(
        "Dependencies of YAHPO are not imported",
        tag="yahpo",
    )


def try_import_backends_message() -> str:
    return _try_import_message(
        "LocalBackend / PythonBackend are not imported", tag=None
    )


def try_import_moo_message() -> str:
    return _try_import_message(
        "Multi Objective Optimization dependencies are not imported", tag="moo"
    )


def _try_import_message(message_text: str, tag: Optional[str]) -> str:
    if tag is None:
        insert = ""
    else:
        insert = "[" + tag + "]"
    return (
        message_text
        + " since dependencies are missing. You can install them with\n"
        + f"   pip install 'syne-tune{insert}'\n"
        + "or (for everything)\n"
        + "   pip install 'syne-tune[extra]'"
    )
