from fastbo.optimizer.schedulers.searchers.utils.common import Configuration
from fastbo.optimizer.schedulers.searchers.bayesopt.tuning_algorithms.common import (
    ExclusionList,
)


class DuplicateDetector:
    def contains(
        self, existing_candidates: ExclusionList, new_candidate: Configuration
    ) -> bool:
        raise NotImplementedError


class DuplicateDetectorNoDetection(DuplicateDetector):
    def contains(
        self, existing_candidates: ExclusionList, new_candidate: Configuration
    ) -> bool:
        return False  # no duplicate detection at all


class DuplicateDetectorIdentical(DuplicateDetector):
    def contains(
        self, existing_candidates: ExclusionList, new_candidate: Configuration
    ) -> bool:
        return existing_candidates.contains(new_candidate)
