
# The implement of 'Learning Sample Difficulty from Pre-trained Models for Reliable Prediction'

Thank you for taking the time to review our code and datasets. This readme describes how to run our proposed method. Notice: Our programs are build based on GPU, it is better to test them in GPU.

## Environment Settings

- numpy==1.20.1
- pytorch_pretrained_vit==0.0.7
- scikit_learn==1.2.1
- scipy==1.6.2
- timm==0.5.4
- torch==1.9.1
- torchvision==0.10.1
- tqdm==4.59.0
- transformers==4.18.0

## How to run

After you have downloaded the repository, you can train the model under sample difficulty-aware entropy regularization by running the example script below.

* For PANDA/CAMELYON16/TCGA

```bash
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python generate_mahalanobis.py --dataset tcga -a univ1 --maha_file ./ssl/maha_dict_univ1_tcga_512.npy --batch_size 4096 --num_classes 2
```

* For regression dataset (please specify the required dataset based on the comments in the code below)

```bash
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python generate_mahalanobis_regression_multigene_harmony_alldata.py --dataset skin -a univ2 --maha_file ./ssl/maha_dict_univ2_skin_harmonyfix.npy --batch_size 4096 
```

