# Supplementary material
These are the supplementary materials for the paper: "The Accuracy Cost of Weakness: A Theoretical Analysis of Fixed-Segment Weak Labeling for Events in Time".

Under review at TMLR.

## Setup virtual environment
A careful person will execute the commands in setup_venv.sh one by one so that nothing unintended goes wrong along the way. Otherwise, simply run

    bash setup_venv.sh

This will install all dependencies in a virtual environment.

To actiave the environment run

    source ./weak-labeling/bin/activate

To deactivate the environment run

    deactivate

## Verify the theoretical analysis of FIX weak labeling in Section 4.2

**Start Jupyter Notebook**:

```bash
jupyter notebook symbolic_verification_of_analysis.ipynb
```

The notebook should open in your browser. Now, simply follow the instructions in the notebook to verify the Theorems.

If the packages are not found, then jupyter is probably using the wrong environment. Following these steps should fix that.

**Select the Correct Kernel**:
   - Open the notebook in Jupyter.
   - Go to the Kernel menu.
   - Select Change Kernel.
   - Choose "Python (weak-labeling)".

This should ensure that your Jupyter notebook uses the correct virtual environment.



## Reproduce the results

    bash produce_figures.sh 1000

This will reproduce all the results figures in Section 6, by running the simulation described in Section 5 with 1000 simulated audio recording samples. This takes hours when simulating 1000 audio recordings, you can reduce this to verify that everything runs correctly and that the images look reasonable, but the process has quite a lot of variance, so do not be surprised if the results look off. I have tried this with 10 samples, and there is a tendency for the curves to end up above the theory lines. But if you run it with 1000 samples the curves converge nicely.

The simulation scripts are "label_accuracy_simulations.py" and "cost_simulations.py". Read these if you want to fully understand the simulation setup.

## Illustrative figures

    python illustrative_figures.py

This will reproduce most of the illustrative figures used in the paper.

## Description of other files

- definitions.py : the definitions presented in the paper
- theorems.py : the theorems presented in the paper
- baby_event_lengths.npy : the event lengths for crying baby events from the NIGENS dataset
- dog_event_lengths.npy : the event lengths for barking dog events from the NIGENS dataset
